/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.qsql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import to.etc.util.RuntimeConversions;
import to.etc.webapp.qsql.IJdbcType;
import to.etc.webapp.qsql.IJdbcTypeFactory;
import to.etc.webapp.qsql.JdbcPropertyMeta;

public class TimestampType
implements IJdbcType,
IJdbcTypeFactory {
    @Override
    public int accept(JdbcPropertyMeta pm) {
        return pm.getActualClass() == Date.class ? 10 : -1;
    }

    @Override
    public IJdbcType createType(JdbcPropertyMeta pm) {
        return this;
    }

    @Override
    public int columnCount() {
        return 1;
    }

    @Override
    public Object convertToInstance(ResultSet rs, int index, JdbcPropertyMeta pm) throws Exception {
        Timestamp ts = rs.getTimestamp(index);
        if (ts == null) {
            return null;
        }
        return new java.sql.Date(ts.getTime());
    }

    @Override
    public void assignParameter(PreparedStatement ps, int index, JdbcPropertyMeta pm, Object value) throws Exception {
        Timestamp ts;
        if (value instanceof Timestamp) {
            ts = (Timestamp)value;
        } else if (value instanceof Date) {
            ts = new Timestamp(((Date)value).getTime());
        } else if (value == null) {
            ts = null;
        } else {
            Date dt = (Date)RuntimeConversions.convertTo((Object)value, Date.class);
            ts = new Timestamp(dt.getTime());
        }
        ps.setTimestamp(index, ts);
    }
}

