/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import to.etc.webapp.query.IBeforeImageCache;

public class DefaultBeforeImageCache
implements IBeforeImageCache {
    @Nonnull
    private final Set<Object> m_uninitializedSet = new HashSet<Object>();
    @Nonnull
    private final Map<Object, Object> m_copyMap = new HashMap<Object, Object>();
    private boolean m_wasNew;

    @Override
    @Nonnull
    public <T> T createImage(@Nonnull Class<T> realclass, @Nonnull T instance, boolean loaded) throws Exception {
        Object copy = this.m_copyMap.get(instance);
        if (null != copy) {
            this.m_wasNew = false;
            if (loaded) {
                this.m_uninitializedSet.remove(copy);
            }
            return (T)copy;
        }
        copy = realclass.newInstance();
        this.m_copyMap.put(instance, copy);
        if (!loaded) {
            this.m_uninitializedSet.add(copy);
        }
        this.m_wasNew = true;
        return (T)copy;
    }

    @Override
    public boolean wasNew() {
        return this.m_wasNew;
    }

    @Override
    public <T> T findBeforeImage(@Nonnull T source) {
        Object res = this.m_copyMap.get(source);
        return (T)res;
    }

    @Override
    public <T> T getBeforeImage(@Nonnull T instance) {
        Object copy = this.m_copyMap.get(instance);
        if (null == copy) {
            return null;
        }
        if (!this.isLoaded(copy)) {
            throw new IllegalStateException("Trying to get the before image of an unloaded instance");
        }
        return null;
    }

    @Override
    public <T> boolean isLoaded(@Nonnull T beforeImage) {
        return !this.m_uninitializedSet.contains(beforeImage);
    }
}

