/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.webapp.query.ICriteriaTableDef;
import to.etc.webapp.query.IIdentifyable;
import to.etc.webapp.query.IQDataContextListener;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QDataContextFactory;
import to.etc.webapp.query.QNotFoundException;
import to.etc.webapp.query.QQueryExecutorRegistry;
import to.etc.webapp.query.QQueryUtils;
import to.etc.webapp.query.QSelection;
import to.etc.webapp.query.QTooManyResultsException;

public abstract class QAbstractDataContext
implements QDataContext {
    @Nonnull
    private List<IQDataContextListener> m_qDataContextListeners = new ArrayList<IQDataContextListener>();
    private QDataContextFactory m_contextFactory;

    protected QAbstractDataContext(QDataContextFactory contextFactory) {
        this.m_contextFactory = contextFactory;
    }

    protected QQueryExecutorRegistry getHandlerFactory() {
        return this.getFactory().getQueryHandlerList();
    }

    @Override
    @Nonnull
    public QDataContextFactory getFactory() {
        return this.m_contextFactory;
    }

    @Override
    public <T> T find(@Nonnull Class<T> clz, @Nonnull Object pk) throws Exception {
        return this.getHandlerFactory().getHandler((QDataContext)this, clz).find((QDataContext)this, clz, pk);
    }

    @Override
    @Nonnull
    public <T> T get(@Nonnull Class<T> clz, @Nonnull Object pk) throws Exception {
        T res = this.find(clz, pk);
        if (res == null) {
            throw new QNotFoundException(clz, pk);
        }
        return res;
    }

    @Override
    public <T> T find(@Nonnull ICriteriaTableDef<T> metatable, @Nonnull Object pk) throws Exception {
        return this.getHandlerFactory().getHandler((QDataContext)this, metatable).find((QDataContext)this, metatable, pk);
    }

    @Override
    @Nonnull
    public <T> T getInstance(@Nonnull Class<T> clz, @Nonnull Object pk) throws Exception {
        return this.getHandlerFactory().getHandler((QDataContext)this, clz).getInstance((QDataContext)this, clz, pk);
    }

    @Override
    @Nonnull
    public <T> T getInstance(@Nonnull ICriteriaTableDef<T> metatable, @Nonnull Object pk) throws Exception {
        return this.getHandlerFactory().getHandler((QDataContext)this, metatable).getInstance((QDataContext)this, metatable, pk);
    }

    @Override
    @Nonnull
    public <T> List<T> query(@Nonnull QCriteria<T> q) throws Exception {
        this.getFactory().getEventListeners().callOnBeforeQuery(this, q);
        return this.getHandlerFactory().getHandler((QDataContext)this, q).query((QDataContext)this, q);
    }

    @Override
    @Nonnull
    public List<Object[]> query(@Nonnull QSelection<?> sel) throws Exception {
        this.getFactory().getEventListeners().callOnBeforeQuery(this, sel);
        return this.getHandlerFactory().getHandler((QDataContext)this, sel).query((QDataContext)this, sel);
    }

    @Override
    @Nonnull
    public <R> List<R> query(@Nonnull Class<R> resultInterface, @Nonnull QSelection<?> sel) throws Exception {
        return QQueryUtils.mapSelectionQuery(this, resultInterface, sel);
    }

    @Override
    @Nullable
    public <R> R queryOne(@Nonnull Class<R> resultInterface, @Nonnull QSelection<?> sel) throws Exception {
        return QQueryUtils.mapSelectionOneQuery(this, resultInterface, sel);
    }

    @Override
    public <T> T queryOne(@Nonnull QCriteria<T> q) throws Exception {
        List<T> res = this.query(q);
        if (res.size() == 0) {
            return null;
        }
        if (res.size() > 1) {
            throw new QTooManyResultsException(q, res.size());
        }
        return res.get(0);
    }

    @Override
    public Object[] queryOne(@Nonnull QSelection<?> sel) throws Exception {
        List<Object[]> res = this.query(sel);
        if (res.size() == 0) {
            return null;
        }
        if (res.size() > 1) {
            throw new QTooManyResultsException(sel, res.size());
        }
        return res.get(0);
    }

    @Override
    public void attach(@Nonnull Object o) throws Exception {
        this.getHandlerFactory().getHandler((QDataContext)this, o).attach(this, o);
    }

    @Override
    public void delete(@Nonnull Object o) throws Exception {
        this.getHandlerFactory().getHandler((QDataContext)this, o).delete(this, o);
    }

    @Override
    public void save(@Nonnull Object o) throws Exception {
        this.getHandlerFactory().getHandler((QDataContext)this, o).save(this, o);
        if (o instanceof IIdentifyable) {
            for (IQDataContextListener icl : this.m_qDataContextListeners) {
                icl.instanceSaved((IIdentifyable)o);
            }
        }
    }

    @Override
    public void refresh(@Nonnull Object o) throws Exception {
        this.getHandlerFactory().getHandler((QDataContext)this, o).refresh(this, o);
    }

    @Override
    public void addListener(@Nonnull IQDataContextListener qDataContextListener) {
        this.m_qDataContextListeners.add(qDataContextListener);
    }
}

