/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.webapp.query.QExistsSubquery;
import to.etc.webapp.query.QField;
import to.etc.webapp.query.QList;
import to.etc.webapp.query.QMultiNode;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;
import to.etc.webapp.query.QQueryRenderer;

public class QBrace {
    @Nonnull
    private List<Object> m_objects = new ArrayList<Object>();
    @Nullable
    private QBrace m_parent;

    public QBrace(@Nullable QBrace parent) {
        this.m_parent = parent;
    }

    @Nullable
    public QBrace getParent() {
        return this.m_parent;
    }

    public void add(Object o) {
        this.m_objects.add(o);
    }

    public String toString() {
        boolean render = this.getParent() == null;
        StringBuilder sb = new StringBuilder(render ? "" : "(");
        Object lastObject = null;
        for (Object object : this.m_objects) {
            if (object instanceof QOperatorNode || object instanceof QList || object instanceof QBrace) {
                if (lastObject instanceof QOperatorNode || lastObject instanceof QBrace || lastObject instanceof QList) {
                    sb.append((Object)QOperation.AND);
                    sb.append(" ");
                }
                if (object instanceof QOperatorNode) {
                    try {
                        QOperatorNode comp = (QOperatorNode)object;
                        QQueryRenderer qr = new QQueryRenderer();
                        comp.visit(qr);
                        sb.append(qr.toString());
                    }
                    catch (Exception x) {
                        sb.append(this.getClass().getName() + ": exception " + x + "]");
                    }
                } else if (object instanceof QList) {
                    QList qList = (QList)object;
                    sb.append("exist in ");
                    sb.append(qList.m_parent.toString());
                    sb.append(".");
                    sb.append(qList.m_listName);
                    sb.append(" : (");
                    sb.append(((QField)qList.getRoot()).qbrace());
                    sb.append(")");
                } else {
                    sb.append(object);
                }
            } else {
                sb.append(object);
            }
            sb.append(" ");
            lastObject = object;
        }
        sb.append(render ? "" : ")");
        return sb.toString();
    }

    @Nonnull
    QOperatorNode toQOperatorNode() throws Exception {
        QMultiNode m = null;
        QOperatorNode lastObject = null;
        QOperatorNode node = null;
        QOperatorNode lastnode = null;
        if (this.m_objects.size() == 0) {
            throw new IllegalStateException("Empty brace contents?");
        }
        Object obj0 = this.m_objects.get(0);
        if (this.m_objects.size() == 1 && obj0 instanceof QOperatorNode) {
            return (QOperatorNode)obj0;
        }
        if (this.m_objects.size() == 1 && obj0 instanceof QList) {
            QExistsSubquery<?> subquery = this.fixSub((QList)obj0);
            return subquery;
        }
        if (this.m_objects.size() == 1 && obj0 instanceof QBrace) {
            QBrace brace = (QBrace)obj0;
            return brace.toQOperatorNode();
        }
        List<Object> objects = this.m_objects;
        ArrayList<Object> newObjects = new ArrayList<Object>();
        HashSet remove = new HashSet();
        HashSet replace = new HashSet();
        HashMap toNode = new HashMap();
        while (objects.size() > 1) {
            QOperatorNode converted;
            QOperatorNode object;
            int i;
            newObjects = new ArrayList();
            for (i = objects.size() - 1; i > -1; --i) {
                object = objects.get(i);
                if (object instanceof QBrace) {
                    QBrace brace = (QBrace)((Object)object);
                    object = node = brace.toQOperatorNode();
                    toNode.put(brace, (QExistsSubquery<?>)node);
                } else if (object instanceof QList) {
                    node = this.fixSub((QList)((Object)object));
                    toNode.put(object, (QExistsSubquery<?>)node);
                    object = node;
                } else if (object instanceof QOperatorNode) {
                    node = object;
                } else {
                    if (object == QOperation.OR && i == objects.size() - 1) {
                        throw new Exception("No restriction found after last OR : " + this);
                    }
                    if (object == QOperation.OR && i == 0) {
                        throw new Exception("No restriction found before first OR : " + this);
                    }
                }
                if (lastObject != null && lastObject instanceof QOperatorNode && object instanceof QOperatorNode) {
                    if (lastnode instanceof QMultiNode && ((QMultiNode)lastnode).getOperation() == QOperation.AND) {
                        m = (QMultiNode)lastnode;
                        m.add(node);
                    } else {
                        m = new QMultiNode(QOperation.AND);
                        m.add(node);
                        m.add(lastnode);
                    }
                    remove.add((QExistsSubquery<?>)node);
                    remove.add((QExistsSubquery<?>)lastnode);
                    replace.add((QExistsSubquery<?>)node);
                    break;
                }
                lastnode = node;
                lastObject = object;
            }
            if (m != null) {
                for (i = 0; i < objects.size(); ++i) {
                    object = objects.get(i);
                    converted = (QOperatorNode)toNode.get(object);
                    if (!remove.contains(object) && !remove.contains(converted)) {
                        newObjects.add(object);
                    }
                    if (!replace.contains(object) && !replace.contains(converted)) continue;
                    newObjects.add(m);
                }
                if (newObjects.size() == 1 && newObjects.get(0) instanceof QOperatorNode) {
                    return (QOperatorNode)newObjects.get(0);
                }
            } else {
                m = new QMultiNode(QOperation.OR);
                for (i = 0; i < objects.size(); ++i) {
                    object = objects.get(i);
                    converted = (QOperatorNode)toNode.get(object);
                    if (object instanceof QOperatorNode) {
                        m.add(object);
                        continue;
                    }
                    if (converted == null) continue;
                    m.add(converted);
                }
                return m;
            }
            objects = newObjects;
            m = null;
            lastObject = null;
            lastnode = null;
            replace.clear();
            remove.clear();
        }
        if (null == m) {
            throw new IllegalStateException("Unexpected: cannot create braced operation");
        }
        return m;
    }

    private QExistsSubquery<?> fixSub(@Nonnull QList<?, ?> qList) throws Exception {
        QExistsSubquery<?> subquery = qList.getSubquery();
        subquery.setRestrictions(((QField)qList.getRoot()).qbrace().toQOperatorNode());
        return subquery;
    }
}

