/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.webapp.query.IQContextContainer;
import to.etc.webapp.query.IQContextFactorySquared;
import to.etc.webapp.query.QContextContainer;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QDataContextFactory;
import to.etc.webapp.query.QEventListenerSet;
import to.etc.webapp.query.QQueryExecutorRegistry;

public final class QContextManager {
    public static final String DEFAULT = "default-context";
    private static final Map<String, IQContextFactorySquared> m_instanceMap = new HashMap<String, IQContextFactorySquared>();
    private static final Map<String, Exception> m_initializedMap = new HashMap<String, Exception>();

    private QContextManager() {
    }

    public static synchronized void setImplementation(@Nonnull String key, @Nonnull IQContextFactorySquared cm) {
        IQContextFactorySquared m = m_instanceMap.get(key);
        if (m != null) {
            Exception where = m_initializedMap.get(key);
            throw new IllegalStateException("Context factory for [" + key + "] has already been used, setting a different implementation is no longer possible", where);
        }
        Exception where = null;
        try {
            throw new RuntimeException("The instance was previously initialized here");
        }
        catch (Exception x) {
            where = x;
            m_instanceMap.put(key, cm);
            m_initializedMap.put(key, where);
            return;
        }
    }

    public static void setImplementation(@Nonnull String key, final @Nonnull QDataContextFactory factory) {
        QContextManager.setImplementation(key, new IQContextFactorySquared(){

            @Override
            @Nonnull
            public QDataContextFactory getDataContextFactory() {
                return factory;
            }
        });
    }

    @Nonnull
    public static synchronized IQContextFactorySquared instance(@Nonnull String key) {
        IQContextFactorySquared m = m_instanceMap.get(key);
        if (m != null) {
            return m;
        }
        throw new IllegalStateException("No context factory-factory found for key=" + key + " - call setImplementation() for that key before using me.");
    }

    @Nonnull
    public static synchronized QDataContextFactory getDataContextFactory(@Nonnull String key) {
        return QContextManager.instance(key).getDataContextFactory();
    }

    @Nonnull
    public static synchronized QDataContextFactory getDataContextFactory() {
        return QContextManager.instance(DEFAULT).getDataContextFactory();
    }

    @Nonnull
    public static QDataContext createUnmanagedContext(@Nonnull String key) throws Exception {
        return QContextManager.instance(key).getDataContextFactory().getDataContext();
    }

    @Nonnull
    public static QDataContext createUnmanagedContext() throws Exception {
        return QContextManager.createUnmanagedContext(DEFAULT);
    }

    @Nonnull
    public static QDataContextFactory getDataContextFactory(@Nonnull String key, @Nonnull QContextContainer cc) {
        QDataContextFactory src = cc.internalGetDataContextFactory();
        if (src != null) {
            return src;
        }
        src = new UnclosableContextFactory(cc, QContextManager.getDataContextFactory());
        cc.internalSetDataContextFactory(src);
        return src;
    }

    @Nonnull
    public static QDataContext getContext(@Nonnull String key, @Nonnull QContextContainer cc) throws Exception {
        QDataContext dc = cc.internalGetSharedContext();
        if (dc == null) {
            dc = QContextManager.getDataContextFactory(key, cc).getDataContext();
            dc.setIgnoreClose(true);
            cc.internalSetSharedContext(dc);
        }
        return dc;
    }

    @Nonnull
    public static QDataContext getContext(@Nonnull String key, @Nonnull IQContextContainer cc) throws Exception {
        return QContextManager.getContext(key, cc.getContextContainer(key));
    }

    public static void closeSharedContext(@Nonnull String key, @Nonnull QContextContainer cc) {
        QDataContext dc = cc.internalGetSharedContext();
        if (dc == null) {
            return;
        }
        cc.internalSetSharedContext(null);
        dc.setIgnoreClose(false);
        dc.close();
    }

    public static void closeSharedContexts(@Nonnull IQContextContainer cc) {
        for (QContextContainer cm : cc.getAllContextContainers()) {
            QDataContext dc = cm.internalGetSharedContext();
            if (null == dc) continue;
            dc.setIgnoreClose(false);
            dc.close();
            cm.internalSetSharedContext(null);
        }
    }

    @Nonnull
    public static QDataContextFactory getDataContextFactory(@Nonnull String key, @Nonnull IQContextContainer container) {
        return QContextManager.getDataContextFactory(key, container.getContextContainer(key));
    }

    private static class UnclosableContextFactory
    implements QDataContextFactory {
        private QContextContainer m_contextContainer;
        private QDataContextFactory m_orig;

        public UnclosableContextFactory(QContextContainer cc, QDataContextFactory orig) {
            if (cc == null) {
                throw new NullPointerException("Container cannot be null");
            }
            if (orig == null) {
                throw new NullPointerException("Root factory cannot be null");
            }
            this.m_orig = orig;
            this.m_contextContainer = cc;
        }

        @Override
        @Nonnull
        public QDataContext getDataContext() throws Exception {
            QDataContext dc = this.m_contextContainer.internalGetSharedContext();
            if (dc != null) {
                return dc;
            }
            dc = this.m_orig.getDataContext();
            dc.setIgnoreClose(true);
            this.m_contextContainer.internalSetSharedContext(dc);
            return dc;
        }

        @Override
        @Nonnull
        public QEventListenerSet getEventListeners() {
            return this.m_orig.getEventListeners();
        }

        @Override
        @Nonnull
        public QQueryExecutorRegistry getQueryHandlerList() {
            return this.m_orig.getQueryHandlerList();
        }
    }
}

