/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.annotations.GProperty;
import to.etc.webapp.query.ICriteriaTableDef;
import to.etc.webapp.query.QFetchStrategy;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;
import to.etc.webapp.query.QOrder;
import to.etc.webapp.query.QPropertySelection;
import to.etc.webapp.query.QRestrictor;
import to.etc.webapp.query.QSelectionColumn;
import to.etc.webapp.query.QSelectionFunction;
import to.etc.webapp.query.QSelectionItem;

public class QCriteriaQueryBase<T>
extends QRestrictor<T> {
    @Nonnull
    private List<QSelectionColumn> m_itemList = Collections.EMPTY_LIST;
    private int m_limit = -1;
    private int m_start = 0;
    private int m_timeout = -1;
    @Nullable
    private String m_testId;
    @Nullable
    private QOperatorNode m_restrictions;
    @Nonnull
    private List<QOrder> m_order = Collections.EMPTY_LIST;
    @Nullable
    private Map<String, Object> m_optionMap;
    private Map<String, QFetchStrategy> m_fetchMap = Collections.EMPTY_MAP;

    protected QCriteriaQueryBase(@Nonnull Class<T> clz) {
        super(clz, QOperation.AND);
    }

    protected QCriteriaQueryBase(@Nonnull ICriteriaTableDef<T> meta) {
        super(meta, QOperation.AND);
    }

    @Override
    @Nullable
    public QOperatorNode getRestrictions() {
        return this.m_restrictions;
    }

    @Override
    public void setRestrictions(@Nullable QOperatorNode restrictions) {
        this.m_restrictions = restrictions;
    }

    @Nonnull
    public List<QSelectionColumn> getColumnList() {
        return this.m_itemList;
    }

    public void setOption(@Nonnull String name, @Nullable Object val) {
        Map<String, Object> optionMap = this.m_optionMap;
        if (optionMap == null) {
            optionMap = this.m_optionMap = new HashMap<String, Object>();
        }
        optionMap.put(name, val);
    }

    public boolean hasOption(@Nonnull String name) {
        Map<String, Object> optionMap = this.m_optionMap;
        return optionMap != null && optionMap.containsKey(name);
    }

    @Nullable
    public Object getOption(@Nonnull String name) {
        Map<String, Object> optionMap = this.m_optionMap;
        return optionMap == null ? null : optionMap.get(name);
    }

    @Nonnull
    public Map<String, QFetchStrategy> getFetchStrategies() {
        return this.m_fetchMap;
    }

    protected void addColumn(@Nonnull QSelectionItem item, @Nullable String alias) {
        QSelectionColumn col = new QSelectionColumn(item, alias);
        if (this.m_itemList.size() == 0) {
            this.m_itemList = new ArrayList<QSelectionColumn>();
        }
        this.m_itemList.add(col);
    }

    protected void addPropertySelection(@Nonnull QSelectionFunction f, @Nonnull @GProperty String prop, @Nullable String alias) {
        if (prop == null || prop.length() == 0) {
            throw new ProgrammerErrorException("The property for a " + (Object)((Object)f) + " selection cannot be null or empty");
        }
        QPropertySelection ps = new QPropertySelection(f, prop);
        this.addColumn(ps, alias);
    }

    @Nonnull
    protected QCriteriaQueryBase<T> selectProperty(@Nonnull @GProperty String property) {
        this.addPropertySelection(QSelectionFunction.PROPERTY, property, null);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> selectProperty(@Nonnull @GProperty String property, @Nullable String alias) {
        this.addPropertySelection(QSelectionFunction.PROPERTY, property, alias);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> max(@Nonnull @GProperty String property) {
        this.addPropertySelection(QSelectionFunction.MAX, property, null);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> max(@Nonnull @GProperty String property, @Nullable String alias) {
        this.addPropertySelection(QSelectionFunction.MAX, property, alias);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> min(@Nonnull @GProperty String property) {
        this.addPropertySelection(QSelectionFunction.MIN, property, null);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> min(@Nonnull @GProperty String property, @Nullable String alias) {
        this.addPropertySelection(QSelectionFunction.MIN, property, alias);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> avg(@Nonnull @GProperty String property) {
        this.addPropertySelection(QSelectionFunction.AVG, property, null);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> avg(@Nonnull @GProperty String property, @Nullable String alias) {
        this.addPropertySelection(QSelectionFunction.AVG, property, alias);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> sum(@Nonnull @GProperty String property) {
        this.addPropertySelection(QSelectionFunction.SUM, property, null);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> sum(@Nonnull @GProperty String property, @Nullable String alias) {
        this.addPropertySelection(QSelectionFunction.SUM, property, alias);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> count(@Nonnull @GProperty String property) {
        this.addPropertySelection(QSelectionFunction.COUNT, property, null);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> count(@Nonnull @GProperty String property, @Nullable String alias) {
        this.addPropertySelection(QSelectionFunction.COUNT, property, alias);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> countDistinct(@Nonnull @GProperty String property) {
        this.addPropertySelection(QSelectionFunction.COUNT_DISTINCT, property, null);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> countDistinct(@Nonnull @GProperty String property, @Nullable String alias) {
        this.addPropertySelection(QSelectionFunction.COUNT_DISTINCT, property, alias);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> distinct(@Nonnull @GProperty String property) {
        this.addPropertySelection(QSelectionFunction.DISTINCT, property, null);
        return this;
    }

    @Nonnull
    protected QCriteriaQueryBase<T> distinct(@Nonnull @GProperty String property, @Nullable String alias) {
        this.addPropertySelection(QSelectionFunction.DISTINCT, property, alias);
        return this;
    }

    @Nonnull
    public QCriteriaQueryBase<T> add(@Nonnull QOrder r) {
        if (this.m_order == Collections.EMPTY_LIST) {
            this.m_order = new ArrayList<QOrder>();
        }
        this.m_order.add(r);
        return this;
    }

    @Nonnull
    public QCriteriaQueryBase<T> ascending(@Nonnull @GProperty String property) {
        this.add(QOrder.ascending(property));
        return this;
    }

    @Nonnull
    public QCriteriaQueryBase<T> descending(@Nonnull @GProperty String property) {
        this.add(QOrder.descending(property));
        return this;
    }

    @Nonnull
    public QCriteriaQueryBase<T> limit(int limit) {
        this.m_limit = limit;
        return this;
    }

    @Nonnull
    public QCriteriaQueryBase<T> start(int start) {
        this.m_start = start;
        return this;
    }

    public final int getLimit() {
        return this.m_limit;
    }

    public final int getStart() {
        return this.m_start;
    }

    @Nonnull
    public final List<QOrder> getOrder() {
        return this.m_order;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    @Nonnull
    public QCriteriaQueryBase<T> fetch(@Nonnull @GProperty String property, @Nonnull QFetchStrategy strategy) {
        if (this.m_fetchMap.size() == 0) {
            this.m_fetchMap = new HashMap<String, QFetchStrategy>();
        }
        this.m_fetchMap.put(property, strategy);
        return this;
    }

    @Nullable
    public String getTestId() {
        return this.m_testId;
    }

    public void setTestId(@Nullable String testId) {
        this.m_testId = testId;
    }
}

