/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.sql.SQLException;
import to.etc.webapp.nls.BundleRef;
import to.etc.webapp.nls.CodeException;
import to.etc.webapp.query.QConstraintViolationException;
import to.etc.webapp.query.QDuplicateKeyException;
import to.etc.webapp.query.QNotFoundException;
import to.etc.webapp.query.QQueryTimeoutException;

public class QDbException
extends CodeException {
    public static final BundleRef BUNDLE = BundleRef.create(QDbException.class, "messages");

    public QDbException(BundleRef bundle, String code, Object ... parameters) {
        super(bundle, code, parameters);
    }

    public QDbException(Throwable t, BundleRef bundle, String code, Object ... parameters) {
        super(t, bundle, code, parameters);
    }

    public QDbException(String code, Object ... parameters) {
        super(BUNDLE, code, parameters);
    }

    public QDbException(Throwable t, String code, Object ... parameters) {
        super(t, BUNDLE, code, parameters);
    }

    public static QDbException findTranslation(Exception x) {
        if (!(x instanceof SQLException)) {
            return null;
        }
        SQLException sx = (SQLException)x;
        String state = QDbException.calcSQLState(sx);
        if (state == null || state.length() < 2) {
            return null;
        }
        String cat = state.substring(0, 2);
        if ("02".equals(cat)) {
            throw new QNotFoundException(x);
        }
        if ("23505".equals(state) || "23515".equals(cat)) {
            return new QDuplicateKeyException(x);
        }
        if ("23".equals(cat) || "27".equals(cat) || "44".equals(cat)) {
            return new QConstraintViolationException(x);
        }
        if ("72000".equals(cat) || x.toString().contains("ORA-01013")) {
            throw new QQueryTimeoutException(x);
        }
        return null;
    }

    private static String calcSQLState(SQLException x) {
        while (x != null) {
            String state = x.getSQLState();
            if (state != null && state.length() != 0) {
                return state;
            }
            x = x.getNextException();
        }
        return null;
    }
}

