/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.query.IRestrictor;
import to.etc.webapp.query.QBrace;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;
import to.etc.webapp.query.QRestriction;

public class QField<R extends QField<R, ?>, T> {
    @Nullable
    private QField<R, ?> m_parent;
    @Nonnull
    protected R m_root;
    @Nullable
    private String m_propertyNameInParent;
    boolean m_isSub = false;
    @Nullable
    protected QCriteria<T> m_criteria;
    protected QBrace m_qBrace;

    public QField(@Nullable R root, @Nullable QField<R, ?> parent, @Nullable String propertyNameInParent) {
        this.m_parent = parent;
        if (root == null) {
            Class cls = (Class)((ParameterizedType)this.getClass().getSuperclass().getGenericSuperclass()).getActualTypeArguments()[1];
            this.m_criteria = QCriteria.create(cls);
            this.m_qBrace = new QBrace(null);
        }
        this.m_root = root == null ? this : root;
        this.m_propertyNameInParent = propertyNameInParent;
    }

    @Nonnull
    final String getPath() {
        QField<R, ?> f;
        ArrayList fields = new ArrayList();
        QField<R, ?> parent = this;
        while ((f = parent.m_parent) != null) {
            fields.add(parent);
            parent = f;
        }
        Collections.reverse(fields);
        StringBuilder sb = new StringBuilder();
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            QField field = (QField)it.next();
            sb.append(field.m_propertyNameInParent);
            if (!it.hasNext()) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    @Nullable
    final String getPropertyNameInParent() {
        return this.m_propertyNameInParent;
    }

    @Nullable
    final QField<R, ?> getParent() {
        return this.m_parent;
    }

    public final String toString() {
        return this.getPath();
    }

    @Nonnull
    public final R gt(T ... t) {
        this.eqOrOr(new IRestrictor<T>(){

            @Override
            @Nonnull
            public QOperatorNode restrict(@Nonnull T value) {
                return QRestriction.gt(QField.this.getPath(), value);
            }
        }, t);
        return this.m_root;
    }

    @Nonnull
    public final R eq(T ... t) {
        this.eqOrOr(new IRestrictor<T>(){

            @Override
            @Nonnull
            public QOperatorNode restrict(@Nonnull T value) {
                return QRestriction.eq(QField.this.getPath(), value);
            }
        }, t);
        return this.m_root;
    }

    @Nonnull
    public final R ne(T ... t) {
        this.eqOrOr(new IRestrictor<T>(){

            @Override
            @Nonnull
            public QOperatorNode restrict(@Nonnull T value) {
                return QRestriction.ne(QField.this.getPath(), value);
            }
        }, t);
        return this.m_root;
    }

    @Nonnull
    public final R or() {
        this.qbrace().add((Object)QOperation.OR);
        return this.m_root;
    }

    protected final void eqOrOr(@Nonnull IRestrictor<T> irestrictor, T ... v) {
        int length = v.length;
        if (v[0] instanceof double[]) {
            length = ((double[])v[0]).length;
        } else if (v[0] instanceof long[]) {
            length = ((long[])v[0]).length;
        } else if (v[0] instanceof boolean[]) {
            length = ((boolean[])v[0]).length;
        }
        if (length == 1) {
            QOperatorNode node = v[0] instanceof double[] ? irestrictor.restrict(new double[]{((double[])v[0])[0]}) : (v[0] instanceof long[] ? irestrictor.restrict(new long[]{((long[])v[0])[0]}) : (v[0] instanceof boolean[] ? irestrictor.restrict((double[])new boolean[]{((boolean[])v[0])[0]}) : irestrictor.restrict((double[])v[0])));
            this.qbrace().add(node);
        } else {
            for (int i = 0; i < length; ++i) {
                QOperatorNode restrict = v[0] instanceof double[] ? irestrictor.restrict(new double[]{((double[])v[0])[i]}) : (v[0] instanceof long[] ? irestrictor.restrict(new long[]{((long[])v[0])[i]}) : (v[0] instanceof boolean[] ? irestrictor.restrict((double[])new boolean[]{((boolean[])v[0])[i]}) : irestrictor.restrict((double[])v[i])));
                this.qbrace().add(restrict);
                if (i >= length - 1) continue;
                this.qbrace().add((Object)QOperation.OR);
            }
        }
    }

    @Nonnull
    public final R $_() {
        QBrace child = new QBrace(this.qbrace());
        this.qbrace().add(child);
        this.qbrace(child);
        return this.m_root;
    }

    @Nonnull
    public final R _$() throws Exception {
        QBrace parent = this.qbrace().getParent();
        if (parent == null) {
            throw new Exception("Trying to close a brace that is not opened.");
        }
        this.qbrace(parent);
        return this.m_root;
    }

    @Nonnull
    final QBrace qbrace() {
        return ((QField)this.m_root).m_qBrace;
    }

    final void qbrace(@Nonnull QBrace brace) {
        ((QField)this.m_root).m_qBrace = brace;
    }

    @Nonnull
    public final List<T> query(@Nonnull QDataContext dc) throws Exception {
        this.validateGetCriteria();
        QCriteria<T> criteria = this.m_criteria;
        if (criteria == null) {
            throw new ProgrammerErrorException("Can only call this on the root field.");
        }
        return dc.query(criteria);
    }

    @Nullable
    public final T queryOne(@Nonnull QDataContext dc) throws Exception {
        this.validateGetCriteria();
        QCriteria<T> criteria = this.m_criteria;
        if (criteria == null) {
            throw new ProgrammerErrorException("Can only call this on the root field.");
        }
        return dc.queryOne(criteria);
    }

    protected final void validateGetCriteria() throws Exception {
        QCriteria<T> criteria = this.m_criteria;
        if (criteria == null) {
            throw new ProgrammerErrorException("Can only call this on the root field.");
        }
        if (!(criteria instanceof QCriteria)) {
            throw new ProgrammerErrorException("Can only call this on the root field.");
        }
        if (this.m_isSub) {
            throw new ProgrammerErrorException("Cannot get criteria from subselect.");
        }
        if (criteria.getRestrictions() == null) {
            criteria.setRestrictions(this.qbrace().toQOperatorNode());
        }
    }

    @Nonnull
    public final QCriteria<?> criteria() {
        QCriteria<T> criteria = ((QField)this.m_root).m_criteria;
        if (criteria == null) {
            throw new ProgrammerErrorException("Null criteria in root");
        }
        return criteria;
    }
}

