/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.webapp.query.QNodeVisitor;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;

public class QMultiNode
extends QOperatorNode {
    private List<QOperatorNode> m_children;

    QMultiNode(QOperation operation) {
        super(operation);
        this.m_children = new ArrayList<QOperatorNode>();
    }

    @Override
    public QMultiNode dup() {
        QMultiNode n = new QMultiNode(this.getOperation());
        for (QOperatorNode child : this.m_children) {
            n.add(child.dup());
        }
        return n;
    }

    public QMultiNode(QOperation operation, QOperatorNode[] ch) {
        super(operation);
        this.m_children = new ArrayList<QOperatorNode>(ch.length);
        for (QOperatorNode qn : ch) {
            if (qn.getOperation() == operation) {
                for (QOperatorNode sub : ((QMultiNode)qn).getChildren()) {
                    this.m_children.add(sub);
                }
                continue;
            }
            this.m_children.add(qn);
        }
    }

    QMultiNode(QOperation operation, List<QOperatorNode> ch) {
        this(operation, ch.toArray(new QOperatorNode[ch.size()]));
    }

    public List<QOperatorNode> getChildren() {
        return this.m_children;
    }

    @Override
    public void visit(@Nonnull QNodeVisitor v) throws Exception {
        v.visitMulti(this);
    }

    void add(QOperatorNode n) {
        this.m_children.add(n);
    }

    void replaceTop(QMultiNode mn) {
        this.m_children.set(this.m_children.size() - 1, mn);
    }
}

