/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.util.List;
import javax.annotation.Nonnull;
import to.etc.webapp.query.QBetweenNode;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QCriteriaQueryBase;
import to.etc.webapp.query.QExistsSubquery;
import to.etc.webapp.query.QLiteral;
import to.etc.webapp.query.QMultiNode;
import to.etc.webapp.query.QMultiSelection;
import to.etc.webapp.query.QNodeVisitor;
import to.etc.webapp.query.QOperatorNode;
import to.etc.webapp.query.QOrder;
import to.etc.webapp.query.QPropertyComparison;
import to.etc.webapp.query.QPropertyIn;
import to.etc.webapp.query.QPropertyJoinComparison;
import to.etc.webapp.query.QPropertySelection;
import to.etc.webapp.query.QSelection;
import to.etc.webapp.query.QSelectionColumn;
import to.etc.webapp.query.QSelectionItem;
import to.etc.webapp.query.QSelectionSubquery;
import to.etc.webapp.query.QSqlRestriction;
import to.etc.webapp.query.QSubQuery;
import to.etc.webapp.query.QUnaryNode;
import to.etc.webapp.query.QUnaryProperty;

public abstract class QNodeVisitorBase
implements QNodeVisitor {
    @Override
    public void visitPropertyComparison(@Nonnull QPropertyComparison n) throws Exception {
        n.getExpr().visit(this);
    }

    @Override
    public void visitPropertyIn(@Nonnull QPropertyIn n) throws Exception {
        n.getExpr().visit(this);
    }

    @Override
    public void visitUnaryNode(@Nonnull QUnaryNode n) throws Exception {
        n.getNode().visit(this);
    }

    @Override
    public void visitUnaryProperty(@Nonnull QUnaryProperty n) throws Exception {
    }

    @Override
    public void visitSqlRestriction(@Nonnull QSqlRestriction v) throws Exception {
    }

    @Override
    public void visitBetween(@Nonnull QBetweenNode n) throws Exception {
        n.getA().visit(this);
        n.getB().visit(this);
    }

    @Override
    public void visitRestrictionsBase(@Nonnull QCriteriaQueryBase<?> n) throws Exception {
        QOperatorNode r = n.getRestrictions();
        if (r != null) {
            r.visit(this);
        }
    }

    @Override
    public void visitCriteria(@Nonnull QCriteria<?> qc) throws Exception {
        this.visitRestrictionsBase(qc);
        this.visitOrderList(qc.getOrder());
    }

    @Override
    public void visitSelection(@Nonnull QSelection<?> s) throws Exception {
        this.visitSelectionColumns(s);
        this.visitRestrictionsBase(s);
        this.visitOrderList(s.getOrder());
    }

    public void visitSelectionColumns(@Nonnull QSelection<?> s) throws Exception {
        for (QSelectionColumn col : s.getColumnList()) {
            col.visit(this);
        }
    }

    @Override
    public void visitOrderList(@Nonnull List<QOrder> orderlist) throws Exception {
        for (QOrder o : orderlist) {
            o.visit(this);
        }
    }

    @Override
    public void visitLiteral(@Nonnull QLiteral n) throws Exception {
    }

    @Override
    public void visitMulti(@Nonnull QMultiNode n) throws Exception {
        for (QOperatorNode o : n.getChildren()) {
            o.visit(this);
        }
    }

    @Override
    public void visitOrder(@Nonnull QOrder o) throws Exception {
    }

    @Override
    public void visitPropertySelection(@Nonnull QPropertySelection n) throws Exception {
    }

    @Override
    public void visitSelectionColumn(@Nonnull QSelectionColumn n) throws Exception {
        n.getItem().visit(this);
    }

    @Override
    public void visitSelectionItem(@Nonnull QSelectionItem n) throws Exception {
    }

    @Override
    public void visitMultiSelection(@Nonnull QMultiSelection n) throws Exception {
        for (QSelectionItem it : n.getItemList()) {
            it.visit(this);
        }
    }

    @Override
    public void visitExistsSubquery(@Nonnull QExistsSubquery<?> q) throws Exception {
        throw new UnsupportedOperationException("Subqueries are not supported");
    }

    @Override
    public void visitSubquery(@Nonnull QSubQuery<?, ?> n) throws Exception {
        throw new UnsupportedOperationException("Subqueries are not supported");
    }

    @Override
    public void visitSelectionSubquery(@Nonnull QSelectionSubquery n) throws Exception {
        throw new UnsupportedOperationException("Subqueries are not supported");
    }

    @Override
    public void visitPropertyJoinComparison(@Nonnull QPropertyJoinComparison qPropertyJoinComparison) throws Exception {
    }
}

