/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.util.Objects;
import javax.annotation.Nonnull;
import to.etc.webapp.query.QNodeVisitor;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;
import to.etc.webapp.query.QSortOrderDirection;

public class QOrder
extends QOperatorNode {
    @Nonnull
    private final String m_property;
    @Nonnull
    private final QSortOrderDirection m_direction;

    public QOrder(@Nonnull QSortOrderDirection direction, @Nonnull String property) {
        super(QOperation.ORDER);
        this.m_direction = direction;
        this.m_property = property;
    }

    @Override
    public QOrder dup() {
        return new QOrder(this.getDirection(), this.getProperty());
    }

    @Nonnull
    public String getProperty() {
        return this.m_property;
    }

    @Nonnull
    public QSortOrderDirection getDirection() {
        return this.m_direction;
    }

    @Nonnull
    public static final QOrder ascending(String name) {
        return new QOrder(QSortOrderDirection.ASC, name);
    }

    @Nonnull
    public static final QOrder descending(String name) {
        return new QOrder(QSortOrderDirection.DESC, name);
    }

    @Nonnull
    public static final QOrder order(String name, QSortOrderDirection dir) {
        return new QOrder(dir, name);
    }

    @Override
    public void visit(@Nonnull QNodeVisitor v) throws Exception {
        v.visitOrder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QOrder qOrder = (QOrder)o;
        return Objects.equals(this.m_property, qOrder.m_property) && Objects.equals((Object)this.m_direction, (Object)qOrder.m_direction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.m_property, this.m_direction});
    }
}

