/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import to.etc.webapp.query.ICriteriaTableDef;
import to.etc.webapp.query.IQueryExecutor;
import to.etc.webapp.query.IQueryExecutorFactory;
import to.etc.webapp.query.QCriteriaQueryBase;
import to.etc.webapp.query.QDataContext;

public final class QQueryExecutorRegistry {
    private List<IQueryExecutorFactory> m_queryRendererList = Collections.EMPTY_LIST;
    private static final QQueryExecutorRegistry m_instance = new QQueryExecutorRegistry();

    public static final QQueryExecutorRegistry getInstance() {
        return m_instance;
    }

    public synchronized int size() {
        return this.m_queryRendererList.size();
    }

    public synchronized void register(IQueryExecutorFactory cf) {
        this.m_queryRendererList = new ArrayList<IQueryExecutorFactory>(this.m_queryRendererList);
        this.m_queryRendererList.add(cf);
    }

    public synchronized List<IQueryExecutorFactory> getQueryRendererList() {
        return this.m_queryRendererList;
    }

    public IQueryExecutor<QDataContext> getHandler(QDataContext root, Class<?> instanceClass) {
        List<IQueryExecutorFactory> res = this.getQueryRendererList();
        for (int i = 0; i < res.size(); ++i) {
            IQueryExecutorFactory xf = res.get(i);
            IQueryExecutor<QDataContext> xc = xf.findContextHandler(root, instanceClass);
            if (xc == null) continue;
            return xc;
        }
        throw new IllegalStateException("None of the QQueryHandlerList's registered accepts a query on class=" + instanceClass);
    }

    public IQueryExecutor<QDataContext> getHandler(QDataContext root, Object recordInstance) {
        List<IQueryExecutorFactory> res = this.getQueryRendererList();
        for (int i = 0; i < res.size(); ++i) {
            IQueryExecutorFactory xf = res.get(i);
            IQueryExecutor<QDataContext> xc = xf.findContextHandler(root, recordInstance);
            if (xc == null) continue;
            return xc;
        }
        throw new IllegalStateException("None of the QQueryHandlerList's registered accepts a data action on record Instance=" + recordInstance);
    }

    public IQueryExecutor<QDataContext> getHandler(QDataContext root, ICriteriaTableDef<?> tableMeta) {
        List<IQueryExecutorFactory> res = this.getQueryRendererList();
        for (int i = 0; i < res.size(); ++i) {
            IQueryExecutorFactory xf = res.get(i);
            IQueryExecutor<QDataContext> xc = xf.findContextHandler(root, tableMeta);
            if (xc == null) continue;
            return xc;
        }
        throw new IllegalStateException("None of the QQueryHandlerList's registered accepts a query on meta-table=" + tableMeta);
    }

    public IQueryExecutor<QDataContext> getHandler(QDataContext root, QCriteriaQueryBase<?> query) {
        if (query.getBaseClass() != null) {
            return this.getHandler(root, query.getBaseClass());
        }
        return this.getHandler(root, query.getMetaTable());
    }
}

