/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.util.StringTool;
import to.etc.webapp.qsql.QQuerySyntaxException;
import to.etc.webapp.query.ICriteriaTableDef;
import to.etc.webapp.query.QBetweenNode;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QCriteriaQueryBase;
import to.etc.webapp.query.QExistsSubquery;
import to.etc.webapp.query.QLiteral;
import to.etc.webapp.query.QMultiSelection;
import to.etc.webapp.query.QNodeVisitor;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;
import to.etc.webapp.query.QOrder;
import to.etc.webapp.query.QPropertyComparison;
import to.etc.webapp.query.QPropertyIn;
import to.etc.webapp.query.QPropertyJoinComparison;
import to.etc.webapp.query.QPropertySelection;
import to.etc.webapp.query.QRenderingVisitorBase;
import to.etc.webapp.query.QSelection;
import to.etc.webapp.query.QSelectionColumn;
import to.etc.webapp.query.QSelectionItem;
import to.etc.webapp.query.QSelectionSubquery;
import to.etc.webapp.query.QSqlRestriction;
import to.etc.webapp.query.QSubQuery;
import to.etc.webapp.query.QUnaryProperty;

public class QQueryRenderer
extends QRenderingVisitorBase
implements QNodeVisitor {
    private StringBuilder m_sb = new StringBuilder(128);
    private int m_orderIndx;
    private int m_currentColumn;

    protected int getCurrentColumn() {
        return this.m_currentColumn;
    }

    protected void setCurrentColumn(int currentColumn) {
        this.m_currentColumn = currentColumn;
    }

    public String toString() {
        return this.m_sb.toString();
    }

    protected QQueryRenderer append(String s) {
        this.m_sb.append(s);
        return this;
    }

    @Override
    protected void appendWhere(String what) {
        this.append(what);
    }

    @Override
    public void visitCriteria(@Nonnull QCriteria<?> qc) throws Exception {
        this.renderFrom(qc);
        if (qc.getRestrictions() != null) {
            this.append(" WHERE ");
        }
        this.visitRestrictionsBase(qc);
        this.visitOrderList(qc.getOrder());
    }

    private void renderFrom(QCriteriaQueryBase<?> qc) {
        this.append("FROM ");
        Class baseClass = qc.getBaseClass();
        if (baseClass != null) {
            this.append(baseClass.getName());
        } else {
            ICriteriaTableDef metaTable = qc.getMetaTable();
            if (metaTable != null) {
                this.append("[META:");
                this.append(metaTable.toString());
                this.append("]");
            } else {
                this.append("[unknown-table]");
            }
        }
    }

    @Override
    public void visitSelection(@Nonnull QSelection<?> s) throws Exception {
        this.renderFrom(s);
        if (s.getColumnList().size() != 0) {
            this.append(" SELECT ");
        }
        this.visitSelectionColumns(s);
        if (s.getRestrictions() != null) {
            this.append(" WHERE ");
        }
        this.visitRestrictionsBase(s);
        this.visitOrderList(s.getOrder());
    }

    @Override
    public void visitSelectionColumn(@Nonnull QSelectionColumn n) throws Exception {
        n.getItem().visit(this);
        String alias = n.getAlias();
        if (null != alias) {
            this.append(" as ").append(alias);
        }
    }

    public void visitSelectionColumns(QSelection<?> s) throws Exception {
        this.m_currentColumn = 0;
        for (QSelectionColumn col : s.getColumnList()) {
            col.visit(this);
        }
    }

    @Override
    public void visitSelectionItem(@Nonnull QSelectionItem n) throws Exception {
        if (this.m_currentColumn++ > 0) {
            this.append(",");
        }
        this.append("[?").append(n.getFunction().name()).append("]");
    }

    @Override
    public void visitPropertySelection(@Nonnull QPropertySelection n) throws Exception {
        if (this.m_currentColumn++ > 0) {
            this.append(",");
        }
        this.append(n.getFunction().name().toLowerCase());
        this.append("(").append(n.getProperty()).append(")");
    }

    @Override
    public void visitPropertyComparison(@Nonnull QPropertyComparison n) throws Exception {
        int oldprec = this.precedenceOpen(n);
        this.append(n.getProperty());
        this.appendOperation(n.getOperation());
        n.getExpr().visit(this);
        this.precedenceClose(oldprec);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitPropertyIn(@Nonnull QPropertyIn n) throws Exception {
        int oldprec = this.precedenceOpen(n);
        this.append(n.getProperty());
        this.append(" in (");
        this.m_curPrec = 0;
        QOperatorNode expr = n.getExpr();
        if (expr instanceof QLiteral) {
            QLiteral lit = (QLiteral)expr;
            Object value = lit.getValue();
            if (!(value instanceof List)) throw new QQuerySyntaxException("Unexpected literal of type " + value + " in 'in' expression for property " + n.getProperty());
            List list = (List)value;
            int ct = 0;
            for (Object o : list) {
                if (ct++ > 0) {
                    this.append(",");
                }
                this.renderValue(o);
            }
        } else {
            expr.visit(this);
        }
        this.append(")");
        this.precedenceClose(oldprec);
    }

    @Override
    public void visitPropertyJoinComparison(@Nonnull QPropertyJoinComparison n) throws Exception {
        int oldprec = this.precedenceOpen(n);
        this.append("[parent].");
        this.append(n.getParentProperty());
        this.appendOperation(n.getOperation());
        this.append(n.getSubProperty());
        this.precedenceClose(oldprec);
    }

    @Override
    public void visitUnaryProperty(@Nonnull QUnaryProperty n) throws Exception {
        int oldprec = this.precedenceOpen(n);
        this.appendOperation(n.getOperation());
        this.append("(");
        this.append(n.getProperty());
        this.append(")");
        this.precedenceClose(oldprec);
    }

    @Override
    public void visitBetween(@Nonnull QBetweenNode n) throws Exception {
        int oldprec = this.precedenceOpen(n);
        this.append(n.getProp());
        this.append(" between ");
        n.getA().visit(this);
        this.append(" and ");
        n.getB().visit(this);
        this.precedenceClose(oldprec);
    }

    @Override
    public void visitOrder(@Nonnull QOrder o) throws Exception {
        if (this.m_orderIndx++ == 0) {
            this.append(" order by ");
        } else {
            this.append(", ");
        }
        this.append(o.getProperty());
        this.append(" ");
        this.append(o.getDirection().toString());
    }

    @Override
    public void visitLiteral(@Nonnull QLiteral n) throws Exception {
        int oldprec = this.precedenceOpen(n);
        Object val = n.getValue();
        this.renderValue(val);
        this.precedenceClose(oldprec);
    }

    private void renderValue(@Nullable Object val) {
        if (val == null) {
            this.append("dbnull");
        } else if (val instanceof Integer) {
            this.append(val.toString());
        } else if (val instanceof Long) {
            this.append(val.toString());
            this.append("L");
        } else if (val instanceof Double) {
            this.append(val.toString());
            this.append("D");
        } else if (val instanceof Float) {
            this.append(val.toString());
            this.append("F");
        } else if (val instanceof BigDecimal) {
            this.append("BigDecimal(");
            this.append(val.toString());
            this.append(")");
        } else if (val instanceof BigInteger) {
            this.append("BigInteger(");
            this.append(val.toString());
            this.append(")");
        } else if (val instanceof String) {
            StringTool.strToJavascriptString((Appendable)this.m_sb, (String)((String)val), (boolean)false);
        } else {
            this.append("Object[");
            this.append(val.toString());
            this.append("]");
        }
    }

    @Override
    protected void appendOperation(QOperation op) {
        this.appendOperation(this.renderOperation(op));
    }

    private void appendOperation(String renderOperation) {
        if (Character.isLetter(renderOperation.charAt(0))) {
            if (this.m_sb.length() > 0 && this.m_sb.charAt(this.m_sb.length() - 1) != ' ') {
                this.append(" ");
            }
            this.append(renderOperation);
            this.append(" ");
        } else {
            this.append(renderOperation);
        }
    }

    @Override
    public void visitSqlRestriction(@Nonnull QSqlRestriction v) throws Exception {
        this.append("SQL['");
        this.append(v.getSql());
        this.append("'");
        if (v.getParameters().length > 0) {
            for (int i = 0; i < v.getParameters().length; ++i) {
                Object val = v.getParameters()[i];
                this.append(", #" + i);
                this.append("=");
                this.append(String.valueOf(val));
            }
        }
        this.append("]");
    }

    @Override
    public void visitExistsSubquery(@Nonnull QExistsSubquery<?> q) throws Exception {
        this.append("exists (select 1 from $[parent." + q.getParentProperty() + "] where ");
        if (q.getRestrictions() == null) {
            this.append("MISSING WHERE - invalid exists subquery)");
        } else {
            q.getRestrictions().visit(this);
            this.append(")");
        }
    }

    @Override
    public void visitSelectionSubquery(QSelectionSubquery q) throws Exception {
        int oldprec = this.m_curPrec;
        this.m_curPrec = 0;
        this.append("(");
        q.getSelectionQuery().visit(this);
        this.append(")");
        this.m_curPrec = oldprec;
    }

    @Override
    public void visitSubquery(@Nonnull QSubQuery<?, ?> n) throws Exception {
        this.visitSelection(n);
    }

    @Override
    public void visitMultiSelection(@Nonnull QMultiSelection n) throws Exception {
        for (QSelectionItem it : n.getItemList()) {
            it.visit(this);
        }
    }

    @Override
    public void visitOrderList(@Nonnull List<QOrder> orderlist) throws Exception {
        for (QOrder o : orderlist) {
            o.visit(this);
        }
    }

    @Override
    public void visitRestrictionsBase(@Nonnull QCriteriaQueryBase<?> n) throws Exception {
        QOperatorNode r = n.getRestrictions();
        QOperatorNode.prune(r);
        if (r != null) {
            r.visit(this);
        }
    }
}

