/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.util.RuntimeConversions;
import to.etc.webapp.qsql.QQuerySyntaxException;
import to.etc.webapp.query.IIdentifyable;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QFld;
import to.etc.webapp.query.QSelection;

public final class QQueryUtils {
    private QQueryUtils() {
    }

    @Nonnull
    public static <R> List<R> mapSelectionQuery(@Nonnull QDataContext dc, @Nonnull Class<R> resultInterface, @Nonnull QSelection<?> sel) throws Exception {
        if (!resultInterface.isInterface()) {
            throw new IllegalArgumentException(resultInterface + " must be an interface");
        }
        List<Object[]> resl = dc.query(sel);
        if (resl.size() == 0) {
            return new ArrayList();
        }
        ProxyFactory<R> pf = QQueryUtils.createResultFactory(resultInterface);
        ArrayList<R> result = new ArrayList<R>(resl.size());
        for (Object[] rv : resl) {
            if (rv == null) continue;
            result.add(pf.createInstance(rv));
        }
        return result;
    }

    @Nullable
    public static <R> R mapSelectionOneQuery(@Nonnull QDataContext dc, @Nonnull Class<R> resultInterface, @Nonnull QSelection<?> sel) throws Exception {
        if (!resultInterface.isInterface()) {
            throw new IllegalArgumentException(resultInterface + " must be an interface");
        }
        Object[] resl = dc.queryOne(sel);
        if (null == resl) {
            return null;
        }
        ProxyFactory<R> pf = QQueryUtils.createResultFactory(resultInterface);
        return pf.createInstance(resl);
    }

    private static <T> ProxyFactory<T> createResultFactory(@Nonnull Class<T> resultInterface) {
        HashMap<Method, Integer> imap = new HashMap<Method, Integer>();
        Method[] mar = resultInterface.getDeclaredMethods();
        for (int index = 0; index < mar.length; ++index) {
            Method m = mar[index];
            QFld fix = m.getAnnotation(QFld.class);
            if (null == fix) {
                throw new QQuerySyntaxException(m + " must be annotated with @QFld to define the location in the result set");
            }
            imap.put(m, fix.value());
        }
        ClassLoader cl = resultInterface.getClassLoader();
        return new ProxyFactory<T>(cl, imap, resultInterface);
    }

    public static <K, T extends IIdentifyable<K>> int queryCount(@Nonnull QDataContext dc, @Nonnull QCriteria<T> q) throws Exception {
        QSelection rest = QSelection.create(q.getBaseClass());
        rest.setRestrictions(q.getRestrictions());
        rest.count("id");
        Object[] count = dc.queryOne(rest.testId(q.getTestId()));
        if (count != null && count.length > 0) {
            return ((Number)count[0]).intValue();
        }
        return 0;
    }

    private static class ProxyFactory<T> {
        private final ClassLoader m_cl;
        private final Map<Method, Integer> m_imap;
        private final Class<T>[] m_resultInterface;

        public ProxyFactory(@Nonnull ClassLoader cl, @Nonnull Map<Method, Integer> imap, @Nonnull Class<T> resultInterface) {
            this.m_cl = cl;
            this.m_imap = imap;
            this.m_resultInterface = new Class[1];
            this.m_resultInterface[0] = resultInterface;
        }

        @Nonnull
        public T createInstance(final @Nonnull Object[] row) {
            return (T)Proxy.newProxyInstance(this.m_cl, this.m_resultInterface, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Integer index = (Integer)m_imap.get(method);
                    if (null == index) {
                        throw new IllegalArgumentException("Unexpected method " + method + " not found in map");
                    }
                    Object rv = row[index];
                    return RuntimeConversions.convertTo((Object)rv, method.getReturnType());
                }
            });
        }
    }
}

