/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.util.List;
import javax.annotation.Nonnull;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QCriteriaQueryBase;
import to.etc.webapp.query.QLiteral;
import to.etc.webapp.query.QMultiNode;
import to.etc.webapp.query.QMultiSelection;
import to.etc.webapp.query.QNodeVisitor;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;
import to.etc.webapp.query.QOrder;
import to.etc.webapp.query.QSelectionColumn;
import to.etc.webapp.query.QSelectionItem;
import to.etc.webapp.query.QUnaryNode;

public abstract class QRenderingVisitorBase
implements QNodeVisitor {
    protected int m_curPrec;

    protected abstract void appendWhere(@Nonnull String var1);

    protected abstract void appendOperation(@Nonnull QOperation var1);

    protected final void precedenceClose(int oldprec) {
        if (oldprec > this.m_curPrec) {
            this.appendWhere(")");
        }
        this.m_curPrec = oldprec;
    }

    protected final int precedenceOpen(@Nonnull QOperatorNode n) {
        int oldprec = this.m_curPrec;
        this.m_curPrec = this.getOperationPrecedence(n.getOperation());
        if (oldprec > this.m_curPrec) {
            this.appendWhere("(");
        }
        return oldprec;
    }

    protected final int getOperationPrecedence(QOperation ot) {
        switch (ot) {
            default: {
                throw new IllegalStateException("Unknown operator " + (Object)((Object)ot));
            }
            case OR: {
                return 10;
            }
            case AND: {
                return 20;
            }
            case NOT: {
                return 25;
            }
            case BETWEEN: 
            case LIKE: 
            case ILIKE: {
                return 30;
            }
            case LT: 
            case LE: 
            case GT: 
            case GE: 
            case EQ: 
            case NE: 
            case ISNULL: 
            case ISNOTNULL: 
            case IN: {
                return 40;
            }
            case LITERAL: 
        }
        return 100;
    }

    protected final String renderOperation(QOperation op) {
        switch (op) {
            default: {
                throw new IllegalStateException("Unexpected operation type=" + (Object)((Object)op));
            }
            case AND: {
                return "and";
            }
            case OR: {
                return "or";
            }
            case NOT: {
                return "not";
            }
            case BETWEEN: {
                return "between";
            }
            case EQ: {
                return "=";
            }
            case NE: {
                return "!=";
            }
            case LT: {
                return "<";
            }
            case LE: {
                return "<=";
            }
            case GT: {
                return ">";
            }
            case GE: {
                return ">=";
            }
            case ILIKE: {
                return "ilike";
            }
            case LIKE: {
                return "like";
            }
            case ISNOTNULL: {
                return "is not null";
            }
            case ISNULL: {
                return "is null";
            }
            case SQL: 
        }
        return "SQL";
    }

    protected String translateOrder(QOrder o) {
        switch (o.getDirection()) {
            default: {
                throw new IllegalStateException("Bad order: " + (Object)((Object)o.getDirection()));
            }
            case ASC: {
                return "asc";
            }
            case DESC: 
        }
        return "desc";
    }

    @Override
    public final void visitMulti(@Nonnull QMultiNode n) throws Exception {
        if (n.getChildren().size() == 0) {
            return;
        }
        if (n.getChildren().size() == 1) {
            n.getChildren().get(0).visit(this);
            return;
        }
        int oldprec = this.precedenceOpen(n);
        int ct = 0;
        for (QOperatorNode c : n.getChildren()) {
            if (ct++ > 0) {
                this.appendOperation(n.getOperation());
            }
            c.visit(this);
        }
        this.precedenceClose(oldprec);
    }

    @Override
    public final void visitUnaryNode(@Nonnull QUnaryNode n) throws Exception {
        switch (n.getOperation()) {
            default: {
                throw new IllegalStateException("Unsupported UNARY operation: " + (Object)((Object)n.getOperation()));
            }
            case SQL: {
                if (!(n.getNode() instanceof QLiteral)) break;
                QLiteral l = (QLiteral)n.getNode();
                this.appendWhere((String)l.getValue());
                return;
            }
            case NOT: {
                if (n.getNode() == null) {
                    return;
                }
                this.appendOperation(n.getOperation());
                int oldprec = this.precedenceOpen(n);
                n.getNode().visit(this);
                this.precedenceClose(oldprec);
                return;
            }
        }
        throw new IllegalStateException("Unsupported UNARY operation: " + (Object)((Object)n.getOperation()));
    }

    @Override
    public void visitCriteria(@Nonnull QCriteria<?> qc) throws Exception {
        this.visitRestrictionsBase(qc);
        this.visitOrderList(qc.getOrder());
    }

    @Override
    public void visitOrderList(@Nonnull List<QOrder> orderlist) throws Exception {
        for (QOrder o : orderlist) {
            o.visit(this);
        }
    }

    @Override
    public void visitMultiSelection(@Nonnull QMultiSelection n) throws Exception {
        for (QSelectionItem it : n.getItemList()) {
            it.visit(this);
        }
    }

    @Override
    public void visitSelectionColumn(@Nonnull QSelectionColumn n) throws Exception {
        n.getItem().visit(this);
    }

    @Override
    public void visitRestrictionsBase(@Nonnull QCriteriaQueryBase<?> n) throws Exception {
        QOperatorNode r = n.getRestrictions();
        QOperatorNode.prune(r);
        if (r != null) {
            r.visit(this);
        }
    }
}

