/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.webapp.annotations.GProperty;
import to.etc.webapp.query.ICriteriaTableDef;
import to.etc.webapp.query.QExistsSubquery;
import to.etc.webapp.query.QField;
import to.etc.webapp.query.QFieldDouble;
import to.etc.webapp.query.QList;
import to.etc.webapp.query.QMultiNode;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;
import to.etc.webapp.query.QRestriction;
import to.etc.webapp.query.QRestrictorImpl;
import to.etc.webapp.query.QSelection;
import to.etc.webapp.query.QSubQuery;
import to.etc.webapp.query.QUnaryNode;

public abstract class QRestrictor<T> {
    @Nullable
    private final Class<T> m_baseClass;
    @Nonnull
    private final Class<T> m_returnClass;
    @Nullable
    private final ICriteriaTableDef<T> m_metaTable;
    @Nonnull
    private QOperation m_combinator;
    private final Set<QSubQuery<?, ?>> m_unusedSubquerySet = new HashSet();

    @Nullable
    public abstract QOperatorNode getRestrictions();

    public abstract void setRestrictions(@Nullable QOperatorNode var1);

    protected QRestrictor(@Nonnull Class<T> baseClass, @Nonnull QOperation combinator) {
        this.m_baseClass = baseClass;
        this.m_returnClass = baseClass;
        this.m_combinator = combinator;
        this.m_metaTable = null;
    }

    protected QRestrictor(@Nonnull ICriteriaTableDef<T> meta, @Nonnull QOperation combinator) {
        this.m_metaTable = meta;
        this.m_returnClass = meta.getDataClass();
        this.m_combinator = combinator;
        this.m_baseClass = null;
    }

    protected QRestrictor(@Nonnull QRestrictor<T> parent, @Nonnull QOperation combinator) {
        this.m_metaTable = parent.getMetaTable();
        this.m_baseClass = parent.getBaseClass();
        this.m_returnClass = parent.getReturnClass();
        this.m_combinator = combinator;
    }

    @Nullable
    public Class<T> getBaseClass() {
        return this.m_baseClass;
    }

    @Nullable
    public ICriteriaTableDef<T> getMetaTable() {
        return this.m_metaTable;
    }

    @Nonnull
    public Class<T> getReturnClass() {
        return this.m_returnClass;
    }

    public final boolean hasRestrictions() {
        return this.getRestrictions() != null;
    }

    protected void internalAdd(@Nonnull QOperatorNode r) {
        QOperatorNode restrictions = this.getRestrictions();
        if (restrictions == null) {
            this.setRestrictions(r);
        } else if (restrictions.getOperation() == this.m_combinator) {
            ((QMultiNode)restrictions).add(r);
        } else {
            QMultiNode comb = new QMultiNode(this.m_combinator);
            comb.add(restrictions);
            comb.add(r);
            this.setRestrictions(comb);
        }
    }

    @Nonnull
    public QRestrictor<T> or() {
        if (this.m_combinator == QOperation.OR) {
            return this;
        }
        QMultiNode or = new QMultiNode(QOperation.OR);
        this.add(or);
        return new QRestrictorImpl(this, or);
    }

    @Nonnull
    public QRestrictor<T> and() {
        if (this.m_combinator == QOperation.AND) {
            return this;
        }
        QMultiNode and = new QMultiNode(QOperation.AND);
        this.add(and);
        return new QRestrictorImpl(this, and);
    }

    @Nonnull
    public QRestrictor<T> not() {
        QMultiNode and = new QMultiNode(QOperation.AND);
        QUnaryNode not = new QUnaryNode(QOperation.NOT, and);
        this.add(not);
        return new QRestrictorImpl(this, and);
    }

    public void mergeCriteria(@Nonnull QRestrictor<T> other) {
        QOperatorNode othertree = other.getRestrictions();
        if (null == othertree) {
            return;
        }
        othertree = othertree.dup();
        QOperatorNode thistree = this.getRestrictions();
        if (null == thistree) {
            this.setRestrictions(othertree);
            return;
        }
        QMultiNode and = new QMultiNode(QOperation.AND, new QOperatorNode[]{thistree, othertree});
        this.setRestrictions(and);
    }

    @Nonnull
    public QRestrictor<T> add(@Nonnull QOperatorNode n) {
        this.internalAdd(n);
        return this;
    }

    @Nonnull
    public QRestrictor<T> eq(@Nonnull @GProperty String property, @Nullable Object value) {
        return this.add(QRestriction.eq(property, value));
    }

    @Nonnull
    public <V, R extends QField<R, T>> QRestrictor<T> eq(@Nonnull QField<R, V> property, @Nonnull V value) {
        return this.eq(property.getPath(), value);
    }

    @Nonnull
    public <V, R extends QField<R, T>> QRestrictor<T> ne(@Nonnull QField<R, V> property, @Nonnull V value) {
        return this.ne(property.getPath(), value);
    }

    @Nonnull
    public QRestrictor<T> eq(@Nonnull @GProperty String property, long value) {
        this.add(QRestriction.eq(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> eq(@Nonnull @GProperty String property, double value) {
        this.add(QRestriction.eq(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> ne(@Nonnull @GProperty String property, @Nullable Object value) {
        this.add(QRestriction.ne(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> ne(@Nonnull @GProperty String property, long value) {
        this.add(QRestriction.ne(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> ne(@Nonnull @GProperty String property, double value) {
        this.add(QRestriction.ne(property, value));
        return this;
    }

    @Nonnull
    public <V> QRestrictor<T> in(@Nonnull @GProperty String property, List<V> inlist) {
        this.add(QRestriction.in(property, inlist));
        return this;
    }

    @Nonnull
    public <V> QRestrictor<T> in(@Nonnull @GProperty String property, QSelection<?> selection) {
        this.add(QRestriction.in(property, selection));
        return this;
    }

    @Nonnull
    public <V, R extends QField<R, T>> QRestrictor<T> in(@Nonnull QField<R, V> property, @Nonnull List<V> value) {
        return this.in(property.getPath(), value);
    }

    @Nonnull
    public QRestrictor<T> gt(@Nonnull @GProperty String property, @Nonnull Object value) {
        this.add(QRestriction.gt(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> gt(@Nonnull @GProperty String property, long value) {
        this.add(QRestriction.gt(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> gt(@Nonnull @GProperty String property, double value) {
        this.add(QRestriction.gt(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> lt(@Nonnull @GProperty String property, @Nonnull Object value) {
        this.add(QRestriction.lt(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> lt(@Nonnull @GProperty String property, long value) {
        this.add(QRestriction.lt(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> lt(@Nonnull @GProperty String property, double value) {
        this.add(QRestriction.lt(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> ge(@Nonnull @GProperty String property, @Nonnull Object value) {
        this.add(QRestriction.ge(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> ge(@Nonnull @GProperty String property, long value) {
        this.add(QRestriction.ge(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> ge(@Nonnull @GProperty String property, double value) {
        this.add(QRestriction.ge(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> le(@Nonnull @GProperty String property, @Nonnull Object value) {
        this.add(QRestriction.le(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> le(@Nonnull @GProperty String property, long value) {
        this.add(QRestriction.le(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> le(@Nonnull @GProperty String property, double value) {
        this.add(QRestriction.le(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> like(@Nonnull @GProperty String property, @Nonnull Object value) {
        this.add(QRestriction.like(property, value));
        return this;
    }

    @Nonnull
    public QRestrictor<T> between(@Nonnull @GProperty String property, @Nonnull Object a, @Nonnull Object b) {
        this.add(QRestriction.between(property, a, b));
        return this;
    }

    @Nonnull
    public QRestrictor<T> ilike(@Nonnull @GProperty String property, @Nonnull Object value) {
        this.add(QRestriction.ilike(property, value));
        return this;
    }

    @Deprecated
    @Nonnull
    public QRestrictor<T> or(@Nonnull QOperatorNode a1, @Nonnull QOperatorNode a2, QOperatorNode ... rest) {
        QOperatorNode[] ar = new QOperatorNode[rest.length + 2];
        ar[0] = a1;
        ar[1] = a2;
        System.arraycopy(rest, 0, ar, 2, rest.length);
        this.add(QRestriction.or(ar));
        return this;
    }

    @Nonnull
    public QRestrictor<T> isnull(@Nonnull @GProperty String property) {
        this.add(QRestriction.isnull(property));
        return this;
    }

    @Nonnull
    public QRestrictor<T> isnotnull(@Nonnull @GProperty String property) {
        this.add(QRestriction.isnotnull(property));
        return this;
    }

    @Nonnull
    public QRestrictor<T> sqlCondition(@Nonnull String sql) {
        this.add(QRestriction.sqlCondition(sql));
        return this;
    }

    @Nonnull
    public QRestrictor<T> sqlCondition(@Nonnull String sql, @Nonnull Object[] params) {
        this.add(QRestriction.sqlCondition(sql, params));
        return this;
    }

    @Nonnull
    public <U> QRestrictor<U> exists(@Nonnull Class<U> childclass, @Nonnull @GProperty(value="U") String childproperty) {
        final QExistsSubquery<U> sq = new QExistsSubquery<U>(this, childclass, childproperty);
        QRestrictor builder = new QRestrictor<U>(childclass, QOperation.AND){

            @Override
            public QOperatorNode getRestrictions() {
                return sq.getRestrictions();
            }

            @Override
            public void setRestrictions(@Nullable QOperatorNode n) {
                sq.setRestrictions(n);
            }
        };
        this.add(sq);
        return builder;
    }

    @Nonnull
    public <P extends QField<P, T>, R extends QField<R, U>, U> QRestrictor<U> exists(@Nonnull QList<P, R> listProperty) throws Exception {
        return this.exists(listProperty.getRootClass(), listProperty.m_listName);
    }

    public <R extends QField<R, T>> QRestrictor<T> eq(@Nonnull QFieldDouble<R> property, double value) {
        return this.eq(property.getPath(), value);
    }

    public <U> QSubQuery<U, T> subquery(@Nonnull Class<U> childClass) throws Exception {
        QSubQuery subQuery = new QSubQuery(this, childClass);
        this.m_unusedSubquerySet.add(subQuery);
        return subQuery;
    }

    public Set<QSubQuery<?, ?>> getUnusedSubquerySet() {
        return this.m_unusedSubquerySet;
    }

    public void internalUseQuery(QSubQuery<?, ?> q) {
        this.m_unusedSubquerySet.remove(q);
    }
}

