/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.query;

import javax.annotation.Nonnull;
import to.etc.webapp.query.QNodeVisitor;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;

public class QSqlRestriction
extends QOperatorNode {
    @Nonnull
    private final String m_sql;
    @Nonnull
    private final Object[] m_parameters;
    @Nonnull
    private final Class<?>[] m_types;

    public QSqlRestriction(@Nonnull String sql, @Nonnull Object[] parameters, @Nonnull Class<?>[] types) {
        super(QOperation.SQL);
        this.m_sql = sql;
        this.m_parameters = parameters;
        this.m_types = types;
        if (parameters.length != types.length) {
            throw new IllegalStateException("Parameter and type array do not have the same size");
        }
    }

    public QSqlRestriction(@Nonnull String sql, @Nonnull Object[] parameters) {
        super(QOperation.SQL);
        this.m_sql = sql;
        this.m_parameters = parameters;
        this.m_types = new Class[parameters.length];
        int i = parameters.length;
        while (--i >= 0) {
            Object o = parameters[i];
            if (null == o) {
                throw new IllegalStateException("Parameter value cannot be null");
            }
            this.m_types[i] = o.getClass();
        }
    }

    @Override
    public QSqlRestriction dup() {
        return new QSqlRestriction(this.getSql(), this.getParameters(), this.getTypes());
    }

    @Override
    public void visit(@Nonnull QNodeVisitor v) throws Exception {
        v.visitSqlRestriction(this);
    }

    @Nonnull
    public String getSql() {
        return this.m_sql;
    }

    @Nonnull
    public Object[] getParameters() {
        return this.m_parameters;
    }

    @Nonnull
    public Class<?>[] getTypes() {
        return this.m_types;
    }
}

