/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.testsupport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.sql.DataSource;
import org.junit.Assume;
import org.junit.internal.AssumptionViolatedException;
import to.etc.dbpool.ConnectionPool;
import to.etc.dbpool.PoolConfig;
import to.etc.dbpool.PoolManager;
import to.etc.dbutil.DbLockKeeper;
import to.etc.util.DeveloperOptions;
import to.etc.util.FileTool;
import to.etc.util.StringTool;
import to.etc.webapp.eventmanager.VpEventManager;
import to.etc.webapp.testsupport.TestLogSink;
import to.etc.webapp.testsupport.TestProperties;

public class TUtilTestProperties {
    private static String m_propertiesLocation;
    @Nullable
    private static TestProperties m_testProperties;
    private static DbConnectionInfo m_dbconn;
    private static DataSource m_rawDS;
    private static String m_viewpointLoginName;
    private static boolean m_gotLoginName;
    private static ConnectionPool m_connectionPool;
    @GuardedBy(value="class")
    private static boolean m_loggingInitialized;
    private static File m_testLogFile;
    private static PrintWriter m_logWriter;
    private static boolean m_testLogInitialized;

    @Nonnull
    public static synchronized TestProperties getTestProperties() {
        TestProperties tp = m_testProperties;
        if (null == tp) {
            Properties p = TUtilTestProperties.findTestProperties();
            if (null == p) {
                System.err.println("TUtilTestProperties: no test.properties file found, using an empty one");
                p = new Properties();
            }
            m_testProperties = tp = new TestProperties(p, null != p);
        }
        return tp;
    }

    /*
     * Loose catch block
     */
    @Nullable
    private static Properties findTestProperties() {
        InputStream is;
        block42: {
            block41: {
                block40: {
                    File uhf;
                    block39: {
                        block38: {
                            block37: {
                                is = null;
                                String env = System.getenv("VPTESTCFG");
                                if (env == null) break block37;
                                Properties properties = TUtilTestProperties.loadProperties(env, "VPTESTCFG");
                                try {
                                    if (is != null) {
                                        is.close();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return properties;
                            }
                            String sysProp = System.getProperty("VPTESTCFG");
                            if (sysProp == null) break block38;
                            Properties properties = TUtilTestProperties.loadProperties(sysProp, "VPTESTCFG");
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return properties;
                        }
                        String testFileName = System.getProperty("testProperties");
                        if (testFileName == null) break block39;
                        is = TUtilTestProperties.class.getResourceAsStream("/resource/test/" + testFileName);
                        if (null == is) {
                            throw new IllegalStateException(testFileName + ": this test.properties file, defined by the 'testProperties' java property does not exist as a resource below /resource/test/");
                        }
                        Properties properties = new Properties();
                        properties.load(is);
                        m_propertiesLocation = "resource /resource/test/" + testFileName + " (through testProperties system property)";
                        Properties properties2 = properties;
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return properties2;
                    }
                    String uh = System.getProperty("user.home");
                    if (uh == null || !(uhf = new File(new File(uh), ".test.properties")).exists()) break block40;
                    Properties properties = FileTool.loadProperties((File)uhf);
                    m_propertiesLocation = uhf + " (from user.home property)";
                    Properties properties3 = properties;
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return properties3;
                }
                File src = new File("./test.properties");
                if (!src.exists()) break block41;
                Properties properties = FileTool.loadProperties((File)src);
                m_propertiesLocation = src.getAbsolutePath() + " (from current directory)";
                Properties properties4 = properties;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return properties4;
            }
            String name = InetAddress.getLocalHost().getCanonicalHostName();
            if (name == null) break block42;
            int dot = name.indexOf(46);
            if (dot != -1) {
                name = name.substring(0, dot);
            }
            if (name.equals("localhost") || (is = TUtilTestProperties.class.getResourceAsStream(name + ".properties")) == null) break block42;
            Properties properties = new Properties();
            m_propertiesLocation = "resource-by-hostname: " + name + ".properties";
            properties.load(is);
            Properties properties5 = properties;
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return properties5;
        }
        try {
            block43: {
                break block43;
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Properties properties = null;
            return properties;
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new RuntimeException(x);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Nonnull
    private static synchronized Properties loadProperties(@Nonnull String sysProp, @Nonnull String propNamen) throws Exception {
        File f = new File(sysProp);
        if (f.exists()) {
            Properties properties = FileTool.loadProperties((File)f);
            m_propertiesLocation = f + " (through environment variable " + propNamen + ")";
            return properties;
        }
        throw new IllegalStateException(propNamen + " System property has nonexisting file " + f);
    }

    public static synchronized String getPropertiesLocation() {
        return m_propertiesLocation;
    }

    public static boolean hasDbConfig() {
        String db = System.getenv("VPTESTDB");
        if (db != null) {
            return true;
        }
        db = System.getProperty("TESTDB");
        if (null != db) {
            return true;
        }
        TestProperties p = TUtilTestProperties.getTestProperties();
        db = p.getProperty("database");
        return db != null;
    }

    public static String getDbString() {
        String db = System.getenv("VPTESTDB");
        if (db != null) {
            return db;
        }
        db = System.getProperty("TESTDB");
        if (null != db) {
            return db;
        }
        TestProperties p = TUtilTestProperties.getTestProperties();
        db = p.getProperty("database");
        if (db != null) {
            return db;
        }
        System.out.println("Database = " + db);
        System.err.println("Database = " + db);
        throw new IllegalStateException("No test database specified.");
    }

    public static final void assumeDatabase() {
        if (!TUtilTestProperties.hasDbConfig()) {
            Assume.assumeFalse((String)"The database is not available", (boolean)true);
            throw new AssumptionViolatedException("The database is not available");
        }
    }

    public static synchronized DbConnectionInfo getDbConn() {
        if (m_dbconn != null) {
            return m_dbconn;
        }
        String db = TUtilTestProperties.getDbString();
        DbConnectionInfo c = new DbConnectionInfo();
        int pos = db.indexOf(64);
        if (pos != -1) {
            String a = db.substring(0, pos);
            String b = db.substring(pos + 1);
            pos = a.indexOf(58);
            if (pos != -1) {
                c.userid = a.substring(0, pos).trim();
                c.password = a.substring(pos + 1).trim();
                pos = b.indexOf(47);
                if (pos != -1) {
                    c.sid = b.substring(pos + 1).trim();
                    b = b.substring(0, pos);
                    pos = b.indexOf(58);
                    c.port = Integer.parseInt(b.substring(pos + 1).trim());
                    c.hostname = b.substring(0, pos);
                    m_dbconn = c;
                    return c;
                }
            }
        }
        throw new IllegalStateException("Invalid database connect string: must be 'user:password@host:port/SID', not " + db);
    }

    public static String getDbSID() {
        return TUtilTestProperties.getDbConn().sid;
    }

    public static synchronized String getViewpointLoginName() {
        if (!m_gotLoginName) {
            m_gotLoginName = true;
            m_viewpointLoginName = TUtilTestProperties.getTestProperties().getProperty("loginid");
            if (m_viewpointLoginName == null) {
                m_viewpointLoginName = "VPC";
            } else if ("ANONYMOUS".equalsIgnoreCase(m_viewpointLoginName)) {
                m_viewpointLoginName = null;
            }
        }
        return m_viewpointLoginName;
    }

    public static synchronized DataSource getRawDataSource() {
        TUtilTestProperties.assumeDatabase();
        if (m_rawDS == null) {
            String url = "jdbc:oracle:thin:@" + TUtilTestProperties.getDbConn().hostname + ":" + TUtilTestProperties.getDbConn().port + ":" + TUtilTestProperties.getDbConn().sid;
            try {
                PoolConfig.Template t = new PoolConfig.Template();
                t.setDriverClassName("oracle.jdbc.driver.OracleDriver");
                t.setUrl(url);
                t.setUid(TUtilTestProperties.getDbConn().userid);
                t.setPw(TUtilTestProperties.getDbConn().password);
                String s = TUtilTestProperties.getTestProperties().getProperty("driverpath");
                if (null != s) {
                    t.setDriverPath(new File(s));
                }
                t.setMinConns(2);
                t.setMaxConns(50);
                m_connectionPool = PoolManager.getInstance().definePool("test", new PoolConfig(t));
                m_connectionPool.initialize();
                m_rawDS = m_connectionPool.getPooledDataSource();
            }
            catch (SQLException x) {
                throw new RuntimeException("cannot init pool: " + x, x);
            }
            VpEventManager.initializeForTest();
            DbLockKeeper.init((DataSource)m_rawDS);
            String defaulttimeout = DeveloperOptions.isDeveloperWorkstation() ? null : "120";
            String poolto = TUtilTestProperties.getString("pool.timeout", defaulttimeout);
            if (poolto != null && !StringTool.isBlank((String)poolto)) {
                int timeout = Integer.parseInt(poolto.trim());
                ConnectionPool pool = PoolManager.getPoolFrom((DataSource)m_rawDS);
                if (null != pool) {
                    pool.setForceTimeout(timeout);
                }
            }
        }
        return m_rawDS;
    }

    public static void initLocale() {
        Locale.setDefault(new Locale("nl", "NL"));
    }

    public static Connection makeRawConnection() throws Exception {
        return TUtilTestProperties.getRawDataSource().getConnection();
    }

    public static void setCommitDisabled(boolean on) {
        if (m_connectionPool == null) {
            return;
        }
        m_connectionPool.setCommitDisabled(on);
    }

    public static synchronized void initLogging() {
        if (m_loggingInitialized) {
            return;
        }
        m_loggingInitialized = true;
    }

    private static boolean openTestLog(@Nullable String s, @Nonnull String where) {
        if (m_testLogFile != null || s == null) {
            return false;
        }
        File f = new File(s);
        try {
            TUtilTestProperties.tryOpenFile(f);
            return true;
        }
        catch (Exception x) {
            System.out.println("test: the log file " + s + " specified in " + where + " cannot be opened: " + x.getMessage());
            return false;
        }
    }

    private static void tryOpenFile(File f) throws Exception {
        m_logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "utf-8"));
        m_testLogFile = f;
        m_logWriter.println("**** JUnit test log created at " + new Date());
        System.out.println("test: log file created as " + f.getCanonicalPath());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    m_logWriter.flush();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        });
    }

    public static boolean isLogging() {
        if (!m_testLogInitialized) {
            m_testLogInitialized = true;
            String s = DeveloperOptions.getString((String)"test.logfile");
            TUtilTestProperties.openTestLog(s, "test.logfile in developer.properties");
            TUtilTestProperties.openTestLog(System.getProperty("test.logfile"), "test.logfile java property");
            TUtilTestProperties.openTestLog(System.getenv("TESTLOGFILE"), "TESTLOGFILE environment variable");
            if (DeveloperOptions.isDeveloperWorkstation()) {
                s = System.getProperty("user.home");
                if (s == null) {
                    s = "/tmp";
                }
                File f = new File(new File(s), "tests.log");
                try {
                    TUtilTestProperties.tryOpenFile(f);
                }
                catch (Exception x) {
                    System.out.println("test: cannot open test log output file " + f + ": " + x.getMessage());
                    return false;
                }
            }
        }
        return m_testLogFile != null;
    }

    @Nullable
    public static File getLogFile() {
        TUtilTestProperties.isLogging();
        return m_testLogFile;
    }

    @Nullable
    public static PrintWriter getLogWriter() {
        TUtilTestProperties.isLogging();
        return m_logWriter;
    }

    @Nullable
    public static TestLogSink getLogSinkIfLogging() {
        if (!TUtilTestProperties.isLogging()) {
            return null;
        }
        TestLogSink tls = new TestLogSink(m_logWriter);
        TUtilTestProperties.logTestName(tls);
        return tls;
    }

    public static TestLogSink getLogSink() {
        if (!TUtilTestProperties.isLogging()) {
            return new TestLogSink();
        }
        TestLogSink tls = new TestLogSink(m_logWriter);
        TUtilTestProperties.logTestName(tls);
        return tls;
    }

    private static void logTestName(TestLogSink tls) {
        Exception x = null;
        try {
            throw new Exception();
        }
        catch (Exception xx) {
            StackTraceElement[] stear;
            x = xx;
            for (StackTraceElement ste : stear = x.getStackTrace()) {
                String cn = ste.getClassName();
                if (cn.startsWith("to.etc.webapp")) continue;
                m_logWriter.append("\n--------------------------------------------------------------------------------------\n").append("-- test: ").append(ste.getMethodName()).append(" in class ").append(cn).append(" ----\n").append("--------------------------------------------------------------------------------------\n");
                return;
            }
            return;
        }
    }

    public static boolean getBoolean(@Nonnull String propertyName, boolean defaultValue) {
        String s = TUtilTestProperties.getString(propertyName, defaultValue ? "true" : "false");
        return "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s);
    }

    @Nullable
    public static String getString(@Nonnull String propertyName, @Nullable String defaultValue) {
        TestProperties tp = TUtilTestProperties.getTestProperties();
        return tp.getProperty(propertyName, defaultValue);
    }

    static {
        TUtilTestProperties.initLocale();
    }

    public static class DbConnectionInfo {
        public String hostname;
        public String sid;
        public String userid;
        public String password;
        public int port;
    }
}

