/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.testsupport;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.util.ClassUtil;
import to.etc.util.PropertyInfo;
import to.etc.webapp.query.IIdentifyable;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QCriteriaQueryBase;
import to.etc.webapp.query.QSelection;
import to.etc.webapp.testsupport.TestDataContextStub;

@DefaultNonNull
public class TestDataContextMock
extends TestDataContextStub {
    private Map<String, List<Object[]>> m_querySelectionMap = new HashMap<String, List<Object[]>>();
    private Map<String, List<?>> m_queryCriteriaMap = new HashMap();
    private Map<String, Object> m_queryOneCriteriaMap = new HashMap<String, Object>();
    private Map<String, Object> m_queryOneSelectionMap = new HashMap<String, Object>();
    public static final String NULL = "[null]";
    private static long m_genericMockInsertId = Long.MAX_VALUE;
    private HashMap<Long, IIdentifyable<Long>> m_insertedByLongId = new HashMap();
    private List<Object> m_inserted = new ArrayList<Object>();
    private List<Object> m_deleted = new ArrayList<Object>();
    @Nullable
    private final ISavedObjectDecorator m_onSaveCallback;
    private final Map<EntityKey, EntityInstance> m_entityByIdMap = new HashMap<EntityKey, EntityInstance>();

    private Long getUniqueId() {
        return m_genericMockInsertId--;
    }

    public TestDataContextMock(@Nullable ISavedObjectDecorator onSaveCallback) {
        this.m_onSaveCallback = onSaveCallback;
    }

    @Override
    public void save(Object o) throws Exception {
        PropertyInfo idProp = ClassUtil.findPropertyInfo(o.getClass(), (String)"id");
        if (null == idProp) {
            System.err.println("mockdc: trying to save " + o.getClass() + " which has no 'id' primary key property, ignored");
            return;
        }
        Object pk = idProp.getValue(o);
        if (null == pk) {
            pk = (long)this.getUniqueId();
            this.assignPk(o, idProp, pk);
        }
        if (null != pk) {
            this.registerInstance(o, pk);
        }
        if (!this.m_inserted.contains(o)) {
            this.m_inserted.add(o);
            ISavedObjectDecorator decorator = this.m_onSaveCallback;
            if (null != decorator) {
                decorator.decorate(o);
            }
        }
    }

    private void registerInstance(Object o, Object pk) {
        EntityKey key = new EntityKey(o.getClass(), pk);
        EntityInstance instance = this.m_entityByIdMap.get(key);
        if (null == instance) {
            instance = new EntityInstance(o);
            this.m_entityByIdMap.put(key, instance);
            instance.setInserted(true);
        } else if (instance.getEntity() != o) {
            throw new IllegalStateException("mockdb: trying to save different instances with the same primary key " + pk + " (class " + o.getClass() + ")");
        }
    }

    private void assignPk(Object o, PropertyInfo idProp, Object id) throws Exception {
        if (idProp.getActualType() != Long.class) {
            System.err.println("mockdc: trying to save " + o.getClass() + " with a non-Long 'id' property that is null- ignored");
        } else {
            Method setter = idProp.getSetter();
            if (null == setter) {
                System.err.println("mockdc: trying to save " + o.getClass() + " whose 'id' property has no setter- ignored");
                return;
            }
            setter.invoke(o, id);
            if (id instanceof Long) {
                this.m_insertedByLongId.put((Long)id, (IIdentifyable)o);
            }
            this.m_inserted.add(o);
        }
    }

    @Override
    public void delete(Object o) throws Exception {
        this.m_deleted.add(o);
        this.m_inserted.remove(o);
        if (this.m_insertedByLongId.values().contains(o)) {
            IIdentifyable longIdentifiable = (IIdentifyable)o;
            this.m_insertedByLongId.remove(longIdentifiable.getId());
        }
    }

    @Override
    @Nonnull
    public <T> T get(@Nonnull Class<T> clz, @Nonnull Object pk) throws Exception {
        T item = this.find(clz, pk);
        if (null == item) {
            throw new IllegalStateException("Not located object of class " + clz + " with ID: " + (Long)pk);
        }
        return item;
    }

    @Override
    @Nonnull
    public <T> T getInstance(@Nonnull Class<T> clz, @Nonnull Object pk) throws Exception {
        T item = this.find(clz, pk);
        if (null != item) {
            return item;
        }
        item = clz.newInstance();
        PropertyInfo idProp = ClassUtil.findPropertyInfo(clz, (String)"id");
        if (null == idProp) {
            throw new IllegalStateException("mockdc: trying to getInstance " + clz + " which has no 'id' primary key property");
        }
        this.assignPk(item, idProp, pk);
        this.registerInstance(item, pk);
        return item;
    }

    @Override
    @Nullable
    public <T> T find(@Nonnull Class<T> clz, @Nonnull Object pk) throws Exception {
        EntityKey key = new EntityKey(clz, pk);
        EntityInstance instance = this.m_entityByIdMap.get(key);
        if (null != instance) {
            Object entity = instance.getEntity();
            if (!clz.isAssignableFrom(entity.getClass())) {
                throw new IllegalStateException("The returned class " + entity.getClass() + " is not assignable to the requested class type " + clz);
            }
            return (T)entity;
        }
        return null;
    }

    @Override
    public List<Object[]> query(QSelection<?> sel) throws Exception {
        String testId = this.checkTestsId(sel);
        return this.processSelectionTestId(testId);
    }

    @Override
    public <T> List<T> query(QCriteria<T> q) throws Exception {
        String testId = this.checkTestsId(q);
        return this.processQueryTestId(testId);
    }

    @Override
    @Nullable
    public <T> T queryOne(@Nonnull QCriteria<T> q) throws Exception {
        String testId = this.checkTestsId(q);
        return this.processQueryOneTestId(testId);
    }

    @Override
    @Nullable
    public Object[] queryOne(@Nonnull QSelection<?> sel) throws Exception {
        String testId = this.checkTestsId(sel);
        return this.processSelectionOneTestId(testId);
    }

    protected <T> List<T> processQueryTestId(String testId) {
        List<?> res = this.m_queryCriteriaMap.get(testId);
        if (null == res) {
            throw new IllegalStateException("Not defined criteria query result for testId: " + testId);
        }
        return res;
    }

    @Nullable
    protected <T> T processQueryOneTestId(String testId) {
        Object res = this.m_queryOneCriteriaMap.get(testId);
        if (null == res) {
            throw new IllegalStateException("Not defined criteria query one result for testId: " + testId);
        }
        if (NULL.equals(res)) {
            return null;
        }
        return (T)res;
    }

    protected List<Object[]> processSelectionTestId(String testId) {
        List<Object[]> res = this.m_querySelectionMap.get(testId);
        if (null == res) {
            throw new IllegalStateException("Not defined selection query result for testId: " + testId);
        }
        return res;
    }

    @Nullable
    protected Object[] processSelectionOneTestId(String testId) {
        Object res = this.m_queryOneSelectionMap.get(testId);
        if (null == res) {
            throw new IllegalStateException("Not defined selection query one result for testId: " + testId);
        }
        if (NULL.equals(res)) {
            return null;
        }
        return (Object[])res;
    }

    public void registerQuery(String testId, List<?> criteriaResult) {
        this.m_queryCriteriaMap.put(testId, criteriaResult);
    }

    public void registerQuery(boolean override, String testId, List<?> criteriaResult) {
        if (!override && null != this.m_queryCriteriaMap.get(testId)) {
            return;
        }
        this.registerQuery(testId, criteriaResult);
    }

    public void registerSelection(String testId, List<Object[]> selectionResult) {
        this.m_querySelectionMap.put(testId, selectionResult);
    }

    public void registerSelection(boolean override, String testId, List<Object[]> selectionResult) {
        if (!override && null != this.m_querySelectionMap.get(testId)) {
            return;
        }
        this.registerSelection(testId, selectionResult);
    }

    public void registerQueryOne(String testId, @Nullable Object queryOneResult) {
        this.m_queryOneCriteriaMap.put(testId, null == queryOneResult ? NULL : queryOneResult);
    }

    public void registerQueryOne(boolean override, String testId, @Nullable Object queryOneResult) {
        if (!override && null != this.m_queryOneCriteriaMap.get(testId)) {
            return;
        }
        this.registerQueryOne(testId, queryOneResult);
    }

    public void registerSelectionOne(String testId, Object ... selectionResult) {
        this.m_queryOneSelectionMap.put(testId, null == selectionResult ? "[null]" : selectionResult);
    }

    public void registerSelectionOne(boolean override, String testId, Object ... selectionResult) {
        if (!override && null != this.m_queryOneSelectionMap.get(testId)) {
            return;
        }
        this.registerSelectionOne(testId, selectionResult);
    }

    private String checkTestsId(QCriteriaQueryBase<?> cqb) {
        String testId = cqb.getTestId();
        if (null == testId) {
            throw new IllegalStateException("No testId defined for: " + cqb);
        }
        return testId;
    }

    public <T> List<T> getInserted(Class<T> type) {
        ArrayList<Object> inserted = new ArrayList<Object>();
        for (Object value : this.m_inserted) {
            if (!value.getClass().isAssignableFrom(type)) continue;
            inserted.add(value);
        }
        return inserted;
    }

    public <T> List<T> getDeleted(Class<T> type) {
        ArrayList<Object> deleted = new ArrayList<Object>();
        for (Object value : this.m_deleted) {
            if (!value.getClass().isAssignableFrom(type)) continue;
            deleted.add(value);
        }
        return deleted;
    }

    public void clear() {
        this.m_insertedByLongId.clear();
        this.m_inserted.clear();
        this.m_deleted.clear();
        this.m_querySelectionMap.clear();
        this.m_querySelectionMap.clear();
        this.m_queryOneCriteriaMap.clear();
        this.m_queryOneSelectionMap.clear();
        this.m_entityByIdMap.clear();
    }

    private static final class EntityInstance {
        private final Object m_entity;
        private boolean m_inserted;
        private boolean m_deleted;

        public EntityInstance(Object entity) {
            this.m_entity = entity;
        }

        public Object getEntity() {
            return this.m_entity;
        }

        public boolean isInserted() {
            return this.m_inserted;
        }

        public void setInserted(boolean inserted) {
            this.m_inserted = inserted;
        }

        public boolean isDeleted() {
            return this.m_deleted;
        }

        public void setDeleted(boolean deleted) {
            this.m_deleted = deleted;
        }
    }

    @DefaultNonNull
    private static final class EntityKey {
        private final Class<?> m_entityClass;
        private final Object m_id;

        public EntityKey(Class<?> entityClass, Object id) {
            this.m_entityClass = entityClass;
            this.m_id = id;
        }

        public Class<?> getEntityClass() {
            return this.m_entityClass;
        }

        public Object getId() {
            return this.m_id;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityKey entityKey = (EntityKey)o;
            if (!this.m_entityClass.equals(entityKey.m_entityClass)) {
                return false;
            }
            return this.m_id.equals(entityKey.m_id);
        }

        public int hashCode() {
            int result = this.m_entityClass.hashCode();
            result = 31 * result + this.m_id.hashCode();
            return result;
        }
    }

    public static interface ISavedObjectDecorator {
        public void decorate(Object var1);
    }
}

