/*
 * Decompiled with CFR 0.152.
 */
package to.etc.webapp.testsupport;

import java.io.IOException;
import javax.annotation.Nonnull;
import to.etc.util.ILogSink;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;

public class TestLogSink
implements ILogSink {
    private final StringBuilder m_sb = new StringBuilder(512);
    private final Appendable m_link;

    public TestLogSink(Appendable link) {
        this.m_link = link;
    }

    public TestLogSink() {
        this.m_link = null;
    }

    public StringBuilder getBuffer() {
        return this.m_sb;
    }

    public String getOutput() {
        return this.m_sb.toString();
    }

    public void log(@Nonnull String msg) {
        this.m_sb.append(msg).append("\n");
        if (this.m_link != null) {
            try {
                this.m_link.append(msg);
                this.m_link.append("\n");
            }
            catch (IOException e) {
                throw WrappedException.wrap((Exception)e);
            }
        }
    }

    public void exception(@Nonnull Throwable t, @Nonnull String msg) {
        this.m_sb.append(msg).append("\n");
        StringTool.strStacktrace((Appendable)this.m_sb, (Throwable)t);
        if (this.m_link != null) {
            try {
                this.m_link.append(msg);
                this.m_link.append("\n");
                StringTool.strStacktrace((Appendable)this.m_link, (Throwable)t);
            }
            catch (IOException e) {
                throw WrappedException.wrap((Exception)e);
            }
        }
    }
}

