/*
 * Decompiled with CFR 0.152.
 */
package to.lova.humanize.time;

import com.vityuk.ginger.LocaleResolver;
import com.vityuk.ginger.LocalizationBuilder;
import com.vityuk.ginger.provider.ResourceNotFoundException;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Locale;
import to.lova.humanize.time.Messages;

public class HumanizeTime
implements LocaleResolver {
    private final Temporal temporal;
    private final Messages messages;
    private final LocaleResolver localeResolver;

    public static String fromNow(Temporal temporal) {
        return HumanizeTime.fromNow(temporal, Locale::getDefault);
    }

    public static String fromNow(Temporal temporal, Locale locale) {
        return HumanizeTime.fromNow(temporal, () -> locale);
    }

    public static String fromNow(Temporal temporal, LocaleResolver localeResolver) {
        return new HumanizeTime(temporal, localeResolver).fromNow();
    }

    public HumanizeTime() {
        this(ZonedDateTime.now());
    }

    public HumanizeTime(Temporal temporal) {
        this(temporal, Locale::getDefault);
    }

    public HumanizeTime(Temporal temporal, Locale locale) {
        this(temporal, () -> locale);
    }

    public HumanizeTime(Temporal temporal, LocaleResolver localeResolver) {
        this.temporal = temporal;
        this.localeResolver = localeResolver;
        this.messages = (Messages)new LocalizationBuilder().withLocaleResolver(this.localeResolver).withResourceLocation("classpath:messages.properties").build().getLocalizable(Messages.class);
    }

    public String fromNow() {
        return this.from(ZonedDateTime.now());
    }

    public String from(Temporal temporal) {
        int years = (int)ChronoUnit.YEARS.between(this.temporal, temporal);
        int months = (int)ChronoUnit.MONTHS.between(this.temporal, temporal);
        int weeks = (int)ChronoUnit.WEEKS.between(this.temporal, temporal);
        int days = (int)ChronoUnit.DAYS.between(this.temporal, temporal);
        int hours = (int)ChronoUnit.HOURS.between(this.temporal, temporal);
        int minutes = (int)ChronoUnit.MINUTES.between(this.temporal, temporal);
        int seconds = (int)ChronoUnit.SECONDS.between(this.temporal, temporal);
        try {
            if (years > 0) {
                return this.messages.yearsAgo(years);
            }
            if (months > 0) {
                return this.messages.monthsAgo(months);
            }
            if (weeks > 0) {
                return this.messages.weeksAgo(weeks);
            }
            if (days > 0) {
                return this.messages.daysAgo(days);
            }
            if (hours > 0) {
                return this.messages.hoursAgo(hours);
            }
            if (minutes > 0) {
                return this.messages.minutesAgo(minutes);
            }
            if (seconds > 0) {
                return this.messages.secondsAgo(seconds);
            }
            if (years < 0) {
                return this.messages.yearsWithin(-years);
            }
            if (months < 0) {
                return this.messages.monthsWithin(-months);
            }
            if (weeks < 0) {
                return this.messages.weeksWithin(-weeks);
            }
            if (days < 0) {
                return this.messages.daysWithin(-days);
            }
            if (hours < 0) {
                return this.messages.hoursWithin(-hours);
            }
            if (minutes < 0) {
                return this.messages.minutesWithin(-minutes);
            }
            if (seconds < 0) {
                return this.messages.secondsWithin(-seconds);
            }
            return this.messages.now();
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return new HumanizeTime(this.temporal, Locale.ENGLISH).from(temporal);
        }
    }

    public Locale getLocale() {
        return this.localeResolver.getLocale();
    }
}

