/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.demo;

import java.io.File;
import java.net.InetAddress;
import java.util.Optional;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.FileLogger;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.XmlConfig;
import net.sourceforge.peers.media.FilePlaybackSoundManager;
import net.sourceforge.peers.media.MediaManager;
import net.sourceforge.peers.media.SoundSource;
import net.sourceforge.peers.rtp.RFC4733;
import net.sourceforge.peers.sip.Utils;
import net.sourceforge.peers.sip.core.useragent.SipListener;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;

public class CallSendAudioFromFileHangupDemo
implements SipListener {
    private Logger logger;
    private Config config;
    private UserAgent userAgent;
    private SipRequest sipRequest;
    private Object registeredSync = new Object();
    private Optional<Boolean> registered;

    public CallSendAudioFromFileHangupDemo(String calleeSipUrl) throws Exception {
        this.logger = new FileLogger(null);
        this.config = new XmlConfig("." + File.separator + UserAgent.CONFIG_FILE, this.logger);
        this.call(calleeSipUrl, "media/message.alaw", SoundSource.DataFormat.ALAW_8KHZ_MONO_LITTLE_ENDIAN);
        this.call(calleeSipUrl, "media/message.raw", SoundSource.DataFormat.LINEAR_PCM_8KHZ_16BITS_SIGNED_MONO_LITTLE_ENDIAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(String callee, String mediaFile, SoundSource.DataFormat mediaFileDataFormat) throws Exception {
        this.userAgent = new UserAgent((SipListener)this, () -> new FilePlaybackSoundManager(mediaFile, mediaFileDataFormat, this.logger), this.config, null, this.logger);
        try {
            this.registered = Optional.empty();
            this.userAgent.register();
            if (!this.isRegistered()) {
                this.logger.error("Not able to register");
            }
            String callId = Utils.generateCallID((InetAddress)this.userAgent.getConfig().getLocalInetAddress());
            this.sipRequest = this.userAgent.invite(callee, callId);
            MediaManager mediaManager = this.userAgent.getMediaManager();
            mediaManager.waitConnected();
            SoundSource soundSource = mediaManager.getSoundSource();
            soundSource.waitFinished();
            mediaManager.waitFinishedSending();
            System.out.println("Hanging up");
            this.userAgent.terminate(this.sipRequest);
        }
        finally {
            this.userAgent.unregister();
            this.userAgent.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRegistered() throws InterruptedException {
        if (this.registered.isPresent()) {
            return this.registered.get();
        }
        Object object = this.registeredSync;
        synchronized (object) {
            while (!this.registered.isPresent()) {
                this.registeredSync.wait();
            }
            return this.registered.get();
        }
    }

    public void registering(SipRequest sipRequest) {
        System.out.println("Registering " + sipRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSuccessful(SipResponse sipResponse) {
        System.out.println("Register successful " + sipResponse);
        this.registered = Optional.of(true);
        Object object = this.registeredSync;
        synchronized (object) {
            this.registeredSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFailed(SipResponse sipResponse) {
        System.out.println("Register failed " + sipResponse);
        this.registered = Optional.of(false);
        Object object = this.registeredSync;
        synchronized (object) {
            this.registeredSync.notifyAll();
        }
    }

    public void incomingCall(SipRequest sipRequest, SipResponse provResponse) {
        System.out.println("Incoming call " + sipRequest + ", " + provResponse);
    }

    public void remoteHangup(SipRequest sipRequest) {
        System.out.println("Remote hangup " + sipRequest);
    }

    public void ringing(SipResponse sipResponse) {
        System.out.println("Ringing " + sipResponse);
    }

    public void calleePickup(SipResponse sipResponse) {
        System.out.println("Callee pickup " + sipResponse);
    }

    public void error(SipResponse sipResponse) {
        System.out.println("Error " + sipResponse);
    }

    public void dtmfEvent(RFC4733.DTMFEvent dtmfEvent, int duration) {
        System.out.println(" DTMF " + dtmfEvent.name());
    }

    public static void main(String[] args) {
        try {
            new CallSendAudioFromFileHangupDemo(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

