/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.demo;

import java.net.SocketException;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.FileLogger;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.demo.CommandsReader;
import net.sourceforge.peers.demo.CustomConfig;
import net.sourceforge.peers.media.AbstractSoundManager;
import net.sourceforge.peers.media.AbstractSoundManagerFactory;
import net.sourceforge.peers.media.javaxsound.JavaxSoundManager;
import net.sourceforge.peers.rtp.RFC4733;
import net.sourceforge.peers.sip.core.useragent.SipListener;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;

public class EventManager
implements SipListener,
AbstractSoundManagerFactory {
    private UserAgent userAgent;
    private SipRequest sipRequest;
    private CommandsReader commandsReader;
    private AbstractSoundManager soundManager;

    public EventManager() throws SocketException {
        CustomConfig config = new CustomConfig();
        FileLogger logger = new FileLogger(null);
        this.soundManager = new JavaxSoundManager(false, (Logger)logger, null);
        this.userAgent = new UserAgent((SipListener)this, (Config)config, (Logger)logger);
        new Thread(){

            @Override
            public void run() {
                try {
                    EventManager.this.userAgent.register();
                }
                catch (SipUriSyntaxException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        this.commandsReader = new CommandsReader(this);
        this.commandsReader.start();
    }

    public void call(final String callee) {
        new Thread(){

            @Override
            public void run() {
                try {
                    EventManager.this.sipRequest = EventManager.this.userAgent.invite(callee, null);
                }
                catch (SipUriSyntaxException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void hangup() {
        new Thread(){

            @Override
            public void run() {
                EventManager.this.userAgent.terminate(EventManager.this.sipRequest);
            }
        }.start();
    }

    public void registering(SipRequest sipRequest) {
    }

    public void registerSuccessful(SipResponse sipResponse) {
    }

    public void registerFailed(SipResponse sipResponse) {
    }

    public void incomingCall(SipRequest sipRequest, SipResponse provResponse) {
    }

    public void remoteHangup(SipRequest sipRequest) {
    }

    public void ringing(SipResponse sipResponse) {
    }

    public void calleePickup(SipResponse sipResponse) {
    }

    public AbstractSoundManager getSoundManager() {
        return this.soundManager;
    }

    public void error(SipResponse sipResponse) {
    }

    public void dtmfEvent(RFC4733.DTMFEvent dtmfEvent, int duration) {
    }

    public static void main(String[] args) {
        try {
            new EventManager();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }
}

