/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.MediaMode;
import net.sourceforge.peers.media.SoundSource;
import net.sourceforge.peers.sdp.Codec;
import net.sourceforge.peers.sip.syntaxencoding.SipURI;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlConfig
implements Config {
    public static final int RTP_DEFAULT_PORT = 8000;
    private static final String XML_CODEC_NODE = "codec";
    private static final String XML_CODEC_ATTR_NAME = "name";
    private static final String XML_CODEC_ATTR_PAYLOADTYPE = "payloadType";
    private Logger logger;
    private File file;
    private Document document;
    private InetAddress localInetAddress;
    private String userPart;
    private String domain;
    private String password;
    private SipURI outboundProxy;
    private int sipPort;
    private MediaMode mediaMode;
    private boolean mediaDebug;
    private String mediaFile;
    private SoundSource.DataFormat mediaFileDataFormat;
    private int rtpPort;
    private String authorizationUsername;
    private List<Codec> supportedCodecs;
    private Node ipAddressNode;
    private Node userPartNode;
    private Node domainNode;
    private Node passwordNode;
    private Node outboundProxyNode;
    private Node sipPortNode;
    private Node mediaModeNode;
    private Node mediaDebugNode;
    private Node mediaFileDataFormatNode;
    private Node mediaFileNode;
    private Node rtpPortNode;
    private Node authUserNode;
    private Node supportedCodecsNode;
    private InetAddress publicInetAddress;

    public XmlConfig(String fileName, Logger logger) {
        DocumentBuilder documentBuilder;
        this.file = new File(fileName);
        this.logger = logger;
        if (!this.file.exists()) {
            logger.debug("config file " + fileName + " not found");
            return;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error("parser configuration exception", e);
            return;
        }
        try {
            this.document = documentBuilder.parse(this.file);
        }
        catch (SAXException e) {
            logger.error("cannot parse " + fileName, e);
            return;
        }
        catch (IOException e) {
            logger.error("IOException", e);
            return;
        }
        Element documentElement = this.document.getDocumentElement();
        this.ipAddressNode = this.getFirstChild(documentElement, "ipAddress");
        String address = this.ipAddressNode.getTextContent();
        try {
            this.localInetAddress = this.isNullOrEmpty(this.ipAddressNode) ? InetAddress.getLocalHost() : InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            logger.error("unknown host: " + address, e);
        }
        this.userPartNode = this.getFirstChild(documentElement, "userPart");
        if (this.isNullOrEmpty(this.userPartNode)) {
            logger.error("userpart not found in configuration file");
        } else {
            this.userPart = this.userPartNode.getTextContent();
        }
        this.authUserNode = this.getFirstChild(documentElement, "authorizationUsername");
        if (!this.isNullOrEmpty(this.authUserNode)) {
            this.authorizationUsername = this.authUserNode.getTextContent();
        }
        this.domainNode = this.getFirstChild(documentElement, "domain");
        if (this.isNullOrEmpty(this.domainNode)) {
            logger.error("domain not found in configuration file");
        } else {
            this.domain = this.domainNode.getTextContent();
        }
        this.passwordNode = this.getFirstChild(documentElement, "password");
        if (!this.isNullOrEmpty(this.passwordNode)) {
            this.password = this.passwordNode.getTextContent();
        }
        this.outboundProxyNode = this.getFirstChild(documentElement, "outboundProxy");
        if (!this.isNullOrEmpty(this.outboundProxyNode)) {
            String uri = this.outboundProxyNode.getTextContent();
            try {
                this.outboundProxy = new SipURI(uri);
            }
            catch (SipUriSyntaxException e) {
                logger.error("sip uri syntax exception: " + uri, e);
            }
        }
        this.sipPortNode = this.getFirstChild(documentElement, "sipPort");
        this.sipPort = this.isNullOrEmpty(this.sipPortNode) ? 5060 : Integer.parseInt(this.sipPortNode.getTextContent());
        this.mediaModeNode = this.getFirstChild(documentElement, "mediaMode");
        this.mediaMode = this.isNullOrEmpty(this.mediaModeNode) ? MediaMode.captureAndPlayback : MediaMode.valueOf(this.mediaModeNode.getTextContent());
        this.mediaDebugNode = this.getFirstChild(documentElement, "mediaDebug");
        this.mediaDebug = this.isNullOrEmpty(this.mediaDebugNode) ? false : Boolean.parseBoolean(this.mediaDebugNode.getTextContent());
        this.mediaFileDataFormatNode = this.getFirstChild(documentElement, "mediaFileDataFormat");
        if (!this.isNullOrEmpty(this.mediaFileDataFormatNode)) {
            this.mediaFileDataFormat = SoundSource.DataFormat.fromShortAlias(this.mediaFileDataFormatNode.getTextContent());
        }
        this.mediaFileNode = this.getFirstChild(documentElement, "mediaFile");
        if (!this.isNullOrEmpty(this.mediaFileNode)) {
            this.mediaFile = this.mediaFileNode.getTextContent();
        }
        if (this.mediaMode == MediaMode.file && (this.mediaFile == null || "".equals(this.mediaFile.trim()))) {
            logger.error("streaming from file but no file provided");
        }
        this.rtpPortNode = this.getFirstChild(documentElement, "rtpPort");
        if (this.isNullOrEmpty(this.rtpPortNode)) {
            this.rtpPort = 8000;
        } else {
            this.rtpPort = Integer.parseInt(this.rtpPortNode.getTextContent());
            if (this.rtpPort % 2 != 0) {
                logger.error("rtp port provided is " + this.rtpPort + " rtp port must be even");
            }
        }
        this.supportedCodecs = new ArrayList<Codec>();
        this.supportedCodecsNode = this.getFirstChild(documentElement, "supportedCodecs");
        if (this.supportedCodecsNode != null && this.supportedCodecsNode.hasChildNodes()) {
            NodeList nodeList = this.supportedCodecsNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!XML_CODEC_NODE.equals(node.getNodeName()) || !node.hasAttributes()) continue;
                Node name = node.getAttributes().getNamedItem(XML_CODEC_ATTR_NAME);
                Node pt = node.getAttributes().getNamedItem(XML_CODEC_ATTR_PAYLOADTYPE);
                Codec codec = new Codec();
                codec.setName(name.getNodeValue());
                codec.setPayloadType(Integer.parseInt(pt.getNodeValue()));
                this.supportedCodecs.add(codec);
            }
        }
    }

    private boolean isNullOrEmpty(Node node) {
        return node == null || "".equals(node.getTextContent().trim());
    }

    private Node getFirstChild(Node parent, String childName) {
        if (parent == null || childName == null) {
            return null;
        }
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!childName.equals(node.getNodeName())) continue;
            return node;
        }
        return null;
    }

    @Override
    public void save() {
        FileWriter fileWriter;
        Transformer transformer;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
        }
        catch (TransformerConfigurationException e) {
            this.logger.error("cannot create transformer", e);
            return;
        }
        try {
            fileWriter = new FileWriter(this.file);
        }
        catch (IOException e) {
            this.logger.error("cannot create file writer", e);
            return;
        }
        StreamResult streamResult = new StreamResult(fileWriter);
        DOMSource domSource = new DOMSource(this.document);
        try {
            transformer.transform(domSource, streamResult);
        }
        catch (TransformerException e) {
            this.logger.error("cannot save config file", e);
            return;
        }
        this.logger.debug("config file saved");
    }

    @Override
    public InetAddress getLocalInetAddress() {
        return this.localInetAddress;
    }

    @Override
    public InetAddress getPublicInetAddress() {
        return this.publicInetAddress;
    }

    @Override
    public String getUserPart() {
        return this.userPart;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public SipURI getOutboundProxy() {
        return this.outboundProxy;
    }

    @Override
    public int getSipPort() {
        return this.sipPort;
    }

    @Override
    public MediaMode getMediaMode() {
        return this.mediaMode;
    }

    @Override
    public boolean isMediaDebug() {
        return this.mediaDebug;
    }

    @Override
    public int getRtpPort() {
        return this.rtpPort;
    }

    @Override
    public String getAuthorizationUsername() {
        return this.authorizationUsername;
    }

    @Override
    public List<Codec> getSupportedCodecs() {
        return this.supportedCodecs;
    }

    @Override
    public SoundSource.DataFormat getMediaFileDataFormat() {
        return this.mediaFileDataFormat;
    }

    @Override
    public String getMediaFile() {
        return this.mediaFile;
    }

    @Override
    public void setLocalInetAddress(InetAddress inetAddress) {
        this.localInetAddress = inetAddress;
        this.ipAddressNode.setTextContent(inetAddress.getHostAddress());
    }

    @Override
    public void setPublicInetAddress(InetAddress inetAddress) {
        this.publicInetAddress = inetAddress;
    }

    @Override
    public void setUserPart(String userPart) {
        this.userPart = userPart;
        this.userPartNode.setTextContent(userPart);
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
        this.domainNode.setTextContent(domain);
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
        this.passwordNode.setTextContent(password);
    }

    @Override
    public void setOutboundProxy(SipURI outboundProxy) {
        this.outboundProxy = outboundProxy;
        if (outboundProxy == null) {
            this.outboundProxyNode.setTextContent("");
        } else {
            this.outboundProxyNode.setTextContent(outboundProxy.toString());
        }
    }

    @Override
    public void setSipPort(int sipPort) {
        this.sipPort = sipPort;
        this.sipPortNode.setTextContent(Integer.toString(sipPort));
    }

    @Override
    public void setMediaMode(MediaMode mediaMode) {
        this.mediaMode = mediaMode;
        this.mediaModeNode.setTextContent(mediaMode.toString());
    }

    @Override
    public void setMediaDebug(boolean mediaDebug) {
        this.mediaDebug = mediaDebug;
        this.mediaDebugNode.setTextContent(Boolean.toString(mediaDebug));
    }

    @Override
    public void setRtpPort(int rtpPort) {
        this.rtpPort = rtpPort;
        this.rtpPortNode.setTextContent(Integer.toString(rtpPort));
    }

    @Override
    public void setAuthorizationUsername(String authorizationUsername) {
        this.authorizationUsername = authorizationUsername;
        this.authUserNode.setTextContent(authorizationUsername);
    }

    @Override
    public void setSupportedCodecs(List<Codec> supportedCodecs) {
        Node node;
        this.supportedCodecs = supportedCodecs;
        if (this.supportedCodecsNode.hasChildNodes()) {
            NodeList nodeList = this.supportedCodecsNode.getChildNodes();
            for (int i = nodeList.getLength() - 1; i > 0; --i) {
                node = nodeList.item(i);
                this.supportedCodecsNode.removeChild(node);
            }
        }
        for (Codec codec : supportedCodecs) {
            node = this.document.createElement(XML_CODEC_NODE);
            node.setAttribute(XML_CODEC_ATTR_NAME, codec.getName());
            node.setAttribute(XML_CODEC_ATTR_PAYLOADTYPE, Integer.toString(codec.getPayloadType()));
            this.supportedCodecsNode.appendChild(node);
        }
    }

    @Override
    public void setMediaFileDataFormat(SoundSource.DataFormat mediaFileDataFormat) {
        this.mediaFileDataFormat = mediaFileDataFormat;
        this.mediaFileDataFormatNode.setTextContent(mediaFileDataFormat.getShortAlias());
    }

    @Override
    public void setMediaFile(String mediaFile) {
        this.mediaFile = mediaFile;
        this.mediaFileNode.setTextContent(mediaFile);
    }
}

