/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.gui;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.gui.CallFrameListener;
import net.sourceforge.peers.gui.CallFrameState;
import net.sourceforge.peers.gui.CallFrameStateFailed;
import net.sourceforge.peers.gui.CallFrameStateInit;
import net.sourceforge.peers.gui.CallFrameStateRemoteHangup;
import net.sourceforge.peers.gui.CallFrameStateRinging;
import net.sourceforge.peers.gui.CallFrameStateSuccess;
import net.sourceforge.peers.gui.CallFrameStateTerminated;
import net.sourceforge.peers.gui.CallFrameStateUac;
import net.sourceforge.peers.gui.CallFrameStateUas;
import net.sourceforge.peers.gui.Keypad;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;

public class CallFrame
implements ActionListener,
WindowListener {
    public static final String HANGUP_ACTION_COMMAND = "hangup";
    public static final String PICKUP_ACTION_COMMAND = "pickup";
    public static final String BUSY_HERE_ACTION_COMMAND = "busyhere";
    public static final String CLOSE_ACTION_COMMAND = "close";
    private CallFrameState state;
    public final CallFrameState INIT;
    public final CallFrameState UAC;
    public final CallFrameState UAS;
    public final CallFrameState RINGING;
    public final CallFrameState SUCCESS;
    public final CallFrameState FAILED;
    public final CallFrameState REMOTE_HANGUP;
    public final CallFrameState TERMINATED;
    private JFrame frame;
    private JPanel callPanel;
    private JPanel callPanelContainer;
    private CallFrameListener callFrameListener;
    private SipRequest sipRequest;

    CallFrame(String remoteParty, String id, CallFrameListener callFrameListener, Logger logger) {
        this.INIT = new CallFrameStateInit(id, this, logger);
        this.UAC = new CallFrameStateUac(id, this, logger);
        this.UAS = new CallFrameStateUas(id, this, logger);
        this.RINGING = new CallFrameStateRinging(id, this, logger);
        this.SUCCESS = new CallFrameStateSuccess(id, this, logger);
        this.FAILED = new CallFrameStateFailed(id, this, logger);
        this.REMOTE_HANGUP = new CallFrameStateRemoteHangup(id, this, logger);
        this.TERMINATED = new CallFrameStateTerminated(id, this, logger);
        this.state = this.INIT;
        this.callFrameListener = callFrameListener;
        this.frame = new JFrame(remoteParty);
        Container contentPane = this.frame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JLabel remotePartyLabel = new JLabel(remoteParty);
        Border remotePartyBorder = BorderFactory.createEmptyBorder(5, 5, 0, 5);
        remotePartyLabel.setBorder(remotePartyBorder);
        remotePartyLabel.setAlignmentX(0.5f);
        contentPane.add(remotePartyLabel);
        Keypad keypad = new Keypad(this);
        contentPane.add(keypad);
        this.callPanelContainer = new JPanel();
        contentPane.add(this.callPanelContainer);
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(this);
    }

    public void callClicked() {
        this.state.callClicked();
    }

    public void incomingCall() {
        this.state.incomingCall();
    }

    public void remoteHangup() {
        this.state.remoteHangup();
    }

    public void error(SipResponse sipResponse) {
        this.state.error(sipResponse);
    }

    public void calleePickup() {
        this.state.calleePickup();
    }

    public void ringing() {
        this.state.ringing();
    }

    void hangup() {
        if (this.callFrameListener != null) {
            this.callFrameListener.hangupClicked(this.sipRequest);
        }
    }

    void pickup() {
        if (this.callFrameListener != null && this.sipRequest != null) {
            this.callFrameListener.pickupClicked(this.sipRequest);
        }
    }

    void busyHere() {
        if (this.callFrameListener != null && this.sipRequest != null) {
            this.frame.dispose();
            this.callFrameListener.busyHereClicked(this.sipRequest);
            this.sipRequest = null;
        }
    }

    void close() {
        this.frame.dispose();
    }

    public void setState(CallFrameState state) {
        this.state.log(state);
        this.state = state;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setCallPanel(JPanel callPanel) {
        if (this.callPanel != null) {
            this.callPanelContainer.remove(this.callPanel);
            this.frame.pack();
        }
        this.callPanelContainer.add(callPanel);
        this.frame.pack();
        this.callPanel = callPanel;
    }

    public void addPageEndLabel(String text) {
        Container container = this.frame.getContentPane();
        JLabel label = new JLabel(text);
        Border labelBorder = BorderFactory.createEmptyBorder(0, 5, 0, 5);
        label.setBorder(labelBorder);
        label.setAlignmentX(0.5f);
        container.add(label);
        this.frame.pack();
    }

    public void setSipRequest(SipRequest sipRequest) {
        this.sipRequest = sipRequest;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        Runnable runnable = null;
        if (HANGUP_ACTION_COMMAND.equals(actionCommand)) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    CallFrame.this.state.hangupClicked();
                }
            };
        } else if (CLOSE_ACTION_COMMAND.equals(actionCommand)) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    CallFrame.this.state.closeClicked();
                }
            };
        } else if (PICKUP_ACTION_COMMAND.equals(actionCommand)) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    CallFrame.this.state.pickupClicked();
                }
            };
        } else if (BUSY_HERE_ACTION_COMMAND.equals(actionCommand)) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    CallFrame.this.state.busyHereClicked();
                }
            };
        }
        if (runnable != null) {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.state.hangupClicked();
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public void keypadEvent(char c) {
        this.callFrameListener.dtmf(c);
    }
}

