/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.gui;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.gui.AboutFrame;
import net.sourceforge.peers.gui.AccountFrame;
import net.sourceforge.peers.gui.CallFrame;
import net.sourceforge.peers.gui.CallFrameListener;
import net.sourceforge.peers.gui.MainFrame;
import net.sourceforge.peers.gui.MainFrameListener;
import net.sourceforge.peers.media.AbstractSoundManager;
import net.sourceforge.peers.media.AbstractSoundManagerFactory;
import net.sourceforge.peers.media.MediaManager;
import net.sourceforge.peers.rtp.RFC4733;
import net.sourceforge.peers.sip.Utils;
import net.sourceforge.peers.sip.core.useragent.SipListener;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import net.sourceforge.peers.sip.transactionuser.Dialog;
import net.sourceforge.peers.sip.transactionuser.DialogManager;
import net.sourceforge.peers.sip.transport.SipMessage;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;

public class EventManager
implements SipListener,
AbstractSoundManagerFactory,
MainFrameListener,
CallFrameListener,
ActionListener {
    public static final String PEERS_URL = "http://peers.sourceforge.net/";
    public static final String PEERS_USER_MANUAL = "http://peers.sourceforge.net/user_manual";
    public static final String ACTION_EXIT = "Exit";
    public static final String ACTION_ACCOUNT = "Account";
    public static final String ACTION_PREFERENCES = "Preferences";
    public static final String ACTION_ABOUT = "About";
    public static final String ACTION_DOCUMENTATION = "Documentation";
    private UserAgent userAgent;
    private MainFrame mainFrame;
    private AccountFrame accountFrame;
    private Map<String, CallFrame> callFrames;
    private boolean closed;
    private Logger logger;
    private AbstractSoundManager soundManager;

    public EventManager(MainFrame mainFrame, String peersHome, Logger logger, AbstractSoundManager soundManager) {
        this.mainFrame = mainFrame;
        this.logger = logger;
        this.soundManager = soundManager;
        this.callFrames = Collections.synchronizedMap(new HashMap());
        this.closed = false;
        try {
            this.userAgent = new UserAgent((SipListener)this, peersHome, logger);
        }
        catch (SocketException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "Peers sip port unavailable, about to leave", "Error", 0);
                    System.exit(1);
                }
            });
        }
    }

    @Override
    public void registering(final SipRequest sipRequest) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EventManager.this.accountFrame != null) {
                    EventManager.this.accountFrame.registering(sipRequest);
                }
                EventManager.this.mainFrame.registering(sipRequest);
            }
        });
    }

    @Override
    public void registerFailed(final SipResponse sipResponse) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EventManager.this.accountFrame != null) {
                    EventManager.this.accountFrame.registerFailed(sipResponse);
                }
                EventManager.this.mainFrame.registerFailed(sipResponse);
            }
        });
    }

    @Override
    public void registerSuccessful(final SipResponse sipResponse) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EventManager.this.closed) {
                    EventManager.this.userAgent.close();
                    System.exit(0);
                    return;
                }
                if (EventManager.this.accountFrame != null) {
                    EventManager.this.accountFrame.registerSuccess(sipResponse);
                }
                EventManager.this.mainFrame.registerSuccessful(sipResponse);
            }
        });
    }

    @Override
    public void calleePickup(final SipResponse sipResponse) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CallFrame callFrame = EventManager.this.getCallFrame(sipResponse);
                if (callFrame != null) {
                    callFrame.calleePickup();
                }
            }
        });
    }

    @Override
    public AbstractSoundManager getSoundManager() {
        return this.soundManager;
    }

    @Override
    public void error(final SipResponse sipResponse) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CallFrame callFrame = EventManager.this.getCallFrame(sipResponse);
                if (callFrame != null) {
                    callFrame.error(sipResponse);
                }
            }
        });
    }

    @Override
    public void dtmfEvent(RFC4733.DTMFEvent dtmfEvent, int duration) {
    }

    @Override
    public void incomingCall(final SipRequest sipRequest, SipResponse provResponse) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SipHeaders sipHeaders = sipRequest.getSipHeaders();
                SipHeaderFieldName sipHeaderFieldName = new SipHeaderFieldName("From");
                SipHeaderFieldValue from = sipHeaders.get(sipHeaderFieldName);
                String fromValue = from.getValue();
                String callId = Utils.getMessageCallId(sipRequest);
                CallFrame callFrame = new CallFrame(fromValue, callId, EventManager.this, EventManager.this.logger);
                EventManager.this.callFrames.put(callId, callFrame);
                callFrame.setSipRequest(sipRequest);
                callFrame.incomingCall();
            }
        });
    }

    @Override
    public void remoteHangup(final SipRequest sipRequest) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CallFrame callFrame = EventManager.this.getCallFrame(sipRequest);
                if (callFrame != null) {
                    callFrame.remoteHangup();
                }
            }
        });
    }

    @Override
    public void ringing(final SipResponse sipResponse) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CallFrame callFrame = EventManager.this.getCallFrame(sipResponse);
                if (callFrame != null) {
                    callFrame.ringing();
                }
            }
        });
    }

    @Override
    public void register() {
        if (this.userAgent == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Config config = EventManager.this.userAgent.getConfig();
                if (config.getPassword() != null) {
                    try {
                        EventManager.this.userAgent.register();
                    }
                    catch (SipUriSyntaxException e) {
                        EventManager.this.mainFrame.setLabelText(e.getMessage());
                    }
                }
            }
        });
    }

    @Override
    public void callClicked(final String uri) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SipRequest sipRequest;
                String callId = Utils.generateCallID(EventManager.this.userAgent.getConfig().getLocalInetAddress());
                CallFrame callFrame = new CallFrame(uri, callId, EventManager.this, EventManager.this.logger);
                EventManager.this.callFrames.put(callId, callFrame);
                try {
                    sipRequest = EventManager.this.userAgent.invite(uri, callId);
                }
                catch (SipUriSyntaxException e) {
                    EventManager.this.logger.error(e.getMessage(), e);
                    EventManager.this.mainFrame.setLabelText(e.getMessage());
                    return;
                }
                callFrame.setSipRequest(sipRequest);
                callFrame.callClicked();
            }
        });
    }

    @Override
    public void windowClosed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    EventManager.this.userAgent.unregister();
                }
                catch (Exception e) {
                    EventManager.this.logger.error("error while unregistering", e);
                }
                EventManager.this.closed = true;
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
    }

    @Override
    public void hangupClicked(final SipRequest sipRequest) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EventManager.this.userAgent.terminate(sipRequest);
            }
        });
    }

    @Override
    public void pickupClicked(final SipRequest sipRequest) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String callId = Utils.getMessageCallId(sipRequest);
                DialogManager dialogManager = EventManager.this.userAgent.getDialogManager();
                Dialog dialog = dialogManager.getDialog(callId);
                EventManager.this.userAgent.acceptCall(sipRequest, dialog);
            }
        });
    }

    @Override
    public void busyHereClicked(final SipRequest sipRequest) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EventManager.this.userAgent.rejectCall(sipRequest);
            }
        });
    }

    @Override
    public void dtmf(final char digit) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MediaManager mediaManager = EventManager.this.userAgent.getMediaManager();
                mediaManager.sendDtmf(digit);
            }
        });
    }

    private CallFrame getCallFrame(SipMessage sipMessage) {
        String callId = Utils.getMessageCallId(sipMessage);
        return this.callFrames.get(callId);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        this.logger.debug("gui actionPerformed() " + action);
        Runnable runnable = null;
        if (ACTION_EXIT.equals(action)) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    EventManager.this.windowClosed();
                }
            };
        } else if (ACTION_ACCOUNT.equals(action)) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    if (EventManager.this.accountFrame == null || !EventManager.this.accountFrame.isDisplayable()) {
                        EventManager.this.accountFrame = new AccountFrame(EventManager.this.userAgent, EventManager.this.logger);
                        EventManager.this.accountFrame.setVisible(true);
                    } else {
                        EventManager.this.accountFrame.requestFocus();
                    }
                }
            };
        } else if (ACTION_PREFERENCES.equals(action)) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "Not implemented yet");
                }
            };
        } else if (ACTION_ABOUT.equals(action)) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    AboutFrame aboutFrame = new AboutFrame(EventManager.this.userAgent.getPeersHome(), EventManager.this.logger);
                    aboutFrame.setVisible(true);
                }
            };
        } else if (ACTION_DOCUMENTATION.equals(action)) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        URI uri = new URI(EventManager.PEERS_USER_MANUAL);
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (URISyntaxException e) {
                        EventManager.this.logger.error(e.getMessage(), e);
                    }
                    catch (IOException e) {
                        EventManager.this.logger.error(e.getMessage(), e);
                    }
                }
            };
        }
        if (runnable != null) {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

