/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import net.sourceforge.peers.Config;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.AbstractSoundManager;
import net.sourceforge.peers.media.AbstractSoundManagerFactory;
import net.sourceforge.peers.media.FilePlaybackSoundManager;
import net.sourceforge.peers.media.javaxsound.JavaxSoundManager;

public class ConfigAbstractSoundManagerFactory
implements AbstractSoundManagerFactory {
    private Config config;
    private String peersHome;
    private Logger logger;

    public ConfigAbstractSoundManagerFactory(Config config, String peersHome, Logger logger) {
        this.config = config;
        this.peersHome = peersHome;
        this.logger = logger;
    }

    @Override
    public AbstractSoundManager getSoundManager() {
        switch (this.config.getMediaMode()) {
            case captureAndPlayback: {
                return new JavaxSoundManager(this.config.isMediaDebug(), this.logger, this.peersHome);
            }
            case echo: {
                return null;
            }
            case file: {
                return new FilePlaybackSoundManager(this.config.getMediaFile(), this.config.getMediaFileDataFormat(), this.logger);
            }
        }
        return null;
    }
}

