/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import net.sourceforge.peers.media.DtmfEventHandler;
import net.sourceforge.peers.rtp.RFC4733;
import net.sourceforge.peers.rtp.RtpPacket;

public class DtmfDecoder {
    private DtmfEventHandler handler;
    private RFC4733.DTMFEvent lastDtmfEvent;
    private int lastDuration;
    private int lastVolume;

    public DtmfDecoder(DtmfEventHandler handler) {
        this.handler = handler;
        this.lastDuration = -1;
    }

    public void processPacket(RtpPacket packet) {
        if (packet.getPayloadType() != 101) {
            throw new RuntimeException("Decoder only supports payloads of type telephone-event");
        }
        if (packet.getData() == null || packet.getData().length != 4) {
            throw new RuntimeException("Only RFC4733 formatted DTMF supported (Unsupported datalength, " + packet.getData().length + " bytes)");
        }
        if ((packet.getData()[1] >> 7 & 1) == 1) {
            int duration = (packet.getData()[2] & 0xFF) << 8 | packet.getData()[1] & 0xFF;
            if (duration != 0) {
                RFC4733.DTMFEvent dtmfEvent = RFC4733.DTMFEvent.fromValue(packet.getData()[0]);
                int volume = packet.getData()[1] & 0x3F;
                if (duration != this.lastDuration || dtmfEvent != this.lastDtmfEvent || this.lastVolume != volume) {
                    this.lastDtmfEvent = dtmfEvent;
                    this.lastDuration = duration;
                    this.lastVolume = volume;
                    this.handler.dtmfDetected(dtmfEvent, duration);
                }
            }
        } else {
            this.lastDuration = -1;
        }
    }
}

