/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import net.sourceforge.peers.Logger;

public abstract class Encoder
implements Runnable {
    private PipedInputStream rawData;
    private PipedOutputStream encodedData;
    private boolean isStopped;
    private FileOutputStream encoderOutput;
    private FileOutputStream encoderInput;
    private boolean mediaDebug;
    private Logger logger;
    private String peersHome;
    private CountDownLatch latch;

    public Encoder(PipedInputStream rawData, PipedOutputStream encodedData, boolean mediaDebug, Logger logger, String peersHome, CountDownLatch latch) {
        this.rawData = rawData;
        this.encodedData = encodedData;
        this.mediaDebug = mediaDebug;
        this.logger = logger;
        this.peersHome = peersHome;
        this.latch = latch;
        this.isStopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int buf_size = 320;
            byte[] buffer = new byte[buf_size];
            if (this.mediaDebug) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
                String date = simpleDateFormat.format(new Date());
                String dir = this.peersHome + File.separator + "media" + File.separator;
                String fileName = dir + date + "_g711_encoder.output";
                try {
                    this.encoderOutput = new FileOutputStream(fileName);
                    fileName = dir + date + "_g711_encoder.input";
                    this.encoderInput = new FileOutputStream(fileName);
                }
                catch (FileNotFoundException e) {
                    this.logger.error("cannot create file", e);
                    if (this.mediaDebug) {
                        try {
                            this.encoderOutput.close();
                            this.encoderInput.close();
                        }
                        catch (IOException e2) {
                            this.logger.error("cannot close file", e2);
                        }
                    }
                    try {
                        this.rawData.close();
                    }
                    catch (IOException e3) {
                        this.logger.error("Error closing raw data input pipe", e3);
                    }
                    try {
                        this.encodedData.close();
                    }
                    catch (IOException e4) {
                        this.logger.error("Error closing encoded data output pipe", e4);
                    }
                    this.latch.countDown();
                    if (this.latch.getCount() != 0L) {
                        try {
                            this.latch.await();
                        }
                        catch (InterruptedException e5) {
                            this.logger.error("interrupt exception", e5);
                        }
                    }
                    return;
                }
            }
            while (!this.isStopped || this.rawDataAvailable() > 0) {
                int numBytesRead;
                block47: {
                    try {
                        int tempBytesRead;
                        for (numBytesRead = 0; numBytesRead < buf_size; numBytesRead += tempBytesRead) {
                            tempBytesRead = this.rawData.read(buffer, numBytesRead, buf_size - numBytesRead);
                            if (tempBytesRead >= 0) continue;
                            this.setStopped(true);
                            break;
                        }
                        if (this.mediaDebug) {
                            try {
                                this.encoderInput.write(buffer, 0, numBytesRead);
                            }
                            catch (IOException e) {
                                this.logger.error("cannot write to file", e);
                            }
                        }
                    }
                    catch (IOException e) {
                        if (this.isStopped) break block47;
                        this.logger.error("Error reading raw data", e);
                    }
                }
                byte[] encodedBuffer = this.process(buffer, numBytesRead);
                if (this.mediaDebug) {
                    try {
                        this.encoderOutput.write(encodedBuffer);
                    }
                    catch (IOException e) {
                        this.logger.error("cannot write to file", e);
                    }
                }
                try {
                    this.encodedData.write(encodedBuffer);
                    this.encodedData.flush();
                }
                catch (IOException e) {
                    this.logger.error("Error writing encoded data", e);
                }
            }
        }
        finally {
            if (this.mediaDebug) {
                try {
                    this.encoderOutput.close();
                    this.encoderInput.close();
                }
                catch (IOException e) {
                    this.logger.error("cannot close file", e);
                }
            }
            try {
                this.rawData.close();
            }
            catch (IOException e) {
                this.logger.error("Error closing raw data input pipe", e);
            }
            try {
                this.encodedData.close();
            }
            catch (IOException e) {
                this.logger.error("Error closing encoded data output pipe", e);
            }
            this.latch.countDown();
            if (this.latch.getCount() != 0L) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException e) {
                    this.logger.error("interrupt exception", e);
                }
            }
        }
    }

    public synchronized void setStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }

    public abstract byte[] process(byte[] var1, int var2);

    private int rawDataAvailable() {
        try {
            return this.rawData.available();
        }
        catch (IOException e) {
            this.logger.error("Error getting amount available raw data. Should never happen", e);
            return 0;
        }
    }
}

