/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.AbstractSoundManager;
import net.sourceforge.peers.media.CaptureRtpSender;
import net.sourceforge.peers.media.DtmfEventHandler;
import net.sourceforge.peers.media.DtmfFactory;
import net.sourceforge.peers.media.Echo;
import net.sourceforge.peers.media.IncomingRtpReader;
import net.sourceforge.peers.media.RtpSender;
import net.sourceforge.peers.media.SoundSource;
import net.sourceforge.peers.rtp.RtpPacket;
import net.sourceforge.peers.rtp.RtpSession;
import net.sourceforge.peers.sdp.Codec;
import net.sourceforge.peers.sip.core.useragent.UserAgent;

public class MediaManager {
    public static final int DEFAULT_CLOCK = 8000;
    private UserAgent userAgent;
    private Object connectedSync = new Object();
    private CaptureRtpSender captureRtpSender;
    private IncomingRtpReader incomingRtpReader;
    private RtpSession rtpSession;
    private DtmfFactory dtmfFactory;
    private Logger logger;
    private DatagramSocket datagramSocket;
    private AbstractSoundManager soundManager;
    private DtmfEventHandler dtmfEventHandler;

    public MediaManager(UserAgent userAgent, DtmfEventHandler dtmfEventHandler, Logger logger) {
        this.userAgent = userAgent;
        this.dtmfEventHandler = dtmfEventHandler;
        this.logger = logger;
        this.dtmfFactory = new DtmfFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCaptureRtpSender(CaptureRtpSender captureRtpSender) {
        this.captureRtpSender = captureRtpSender;
        Object object = this.connectedSync;
        synchronized (object) {
            this.connectedSync.notifyAll();
        }
    }

    public CaptureRtpSender getCaptureRtpSender() {
        return this.captureRtpSender;
    }

    private void startRtpSessionOnSuccessResponse(String localAddress, String remoteAddress, int remotePort, Codec codec, SoundSource soundSource) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(localAddress);
        }
        catch (UnknownHostException e) {
            this.logger.error("unknown host: " + localAddress, e);
            return;
        }
        this.rtpSession = new RtpSession(inetAddress, this.datagramSocket, this.userAgent.isMediaDebug(), this.logger, this.userAgent.getPeersHome());
        try {
            inetAddress = InetAddress.getByName(remoteAddress);
            this.rtpSession.setRemoteAddress(inetAddress);
        }
        catch (UnknownHostException e) {
            this.logger.error("unknown host: " + remoteAddress, e);
        }
        this.rtpSession.setRemotePort(remotePort);
        try {
            this.setCaptureRtpSender(new CaptureRtpSender(this.rtpSession, soundSource, this.userAgent.isMediaDebug(), codec, this.logger, this.userAgent.getPeersHome()));
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
            return;
        }
        try {
            this.captureRtpSender.start();
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
        }
    }

    public void successResponseReceived(String localAddress, String remoteAddress, int remotePort, Codec codec) {
        switch (this.userAgent.getMediaMode()) {
            case captureAndPlayback: 
            case file: {
                if (this.soundManager != null) {
                    this.soundManager.close();
                }
                this.soundManager = this.userAgent.getAbstractSoundManagerFactory().getSoundManager();
                this.soundManager.init();
                this.startRtpSessionOnSuccessResponse(localAddress, remoteAddress, remotePort, codec, this.soundManager);
                try {
                    this.incomingRtpReader = new IncomingRtpReader(this.captureRtpSender.getRtpSession(), this.soundManager, codec, this.dtmfEventHandler, this.logger);
                }
                catch (IOException e) {
                    this.logger.error("input/output error", e);
                    return;
                }
                this.incomingRtpReader.start();
                break;
            }
            case echo: {
                Echo echo;
                try {
                    echo = new Echo(this.datagramSocket, remoteAddress, remotePort, this.logger);
                }
                catch (UnknownHostException e) {
                    this.logger.error("unknown host amongst " + localAddress + " or " + remoteAddress);
                    return;
                }
                this.userAgent.setEcho(echo);
                Thread echoThread = new Thread((Runnable)echo, Echo.class.getSimpleName());
                echoThread.start();
                break;
            }
        }
    }

    private void startRtpSession(String destAddress, int destPort, Codec codec, SoundSource soundSource) {
        this.rtpSession = new RtpSession(this.userAgent.getConfig().getLocalInetAddress(), this.datagramSocket, this.userAgent.isMediaDebug(), this.logger, this.userAgent.getPeersHome());
        try {
            InetAddress inetAddress = InetAddress.getByName(destAddress);
            this.rtpSession.setRemoteAddress(inetAddress);
        }
        catch (UnknownHostException e) {
            this.logger.error("unknown host: " + destAddress, e);
        }
        this.rtpSession.setRemotePort(destPort);
        try {
            this.setCaptureRtpSender(new CaptureRtpSender(this.rtpSession, soundSource, this.userAgent.isMediaDebug(), codec, this.logger, this.userAgent.getPeersHome()));
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
            return;
        }
        try {
            this.captureRtpSender.start();
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
        }
    }

    public void handleAck(String destAddress, int destPort, Codec codec) {
        switch (this.userAgent.getMediaMode()) {
            case captureAndPlayback: 
            case file: {
                if (this.soundManager != null) {
                    this.soundManager.close();
                }
                this.soundManager = this.userAgent.getAbstractSoundManagerFactory().getSoundManager();
                this.soundManager.init();
                this.startRtpSession(destAddress, destPort, codec, this.soundManager);
                try {
                    this.incomingRtpReader = new IncomingRtpReader(this.rtpSession, this.soundManager, codec, this.dtmfEventHandler, this.logger);
                }
                catch (IOException e) {
                    this.logger.error("input/output error", e);
                    return;
                }
                this.incomingRtpReader.start();
                break;
            }
            case echo: {
                Echo echo;
                try {
                    echo = new Echo(this.datagramSocket, destAddress, destPort, this.logger);
                }
                catch (UnknownHostException e) {
                    this.logger.error("unknown host amongst " + this.userAgent.getConfig().getLocalInetAddress().getHostAddress() + " or " + destAddress);
                    return;
                }
                this.userAgent.setEcho(echo);
                Thread echoThread = new Thread((Runnable)echo, Echo.class.getSimpleName());
                echoThread.start();
                break;
            }
        }
    }

    public void updateRemote(String destAddress, int destPort, Codec codec) {
        switch (this.userAgent.getMediaMode()) {
            case captureAndPlayback: 
            case file: {
                try {
                    InetAddress inetAddress = InetAddress.getByName(destAddress);
                    this.rtpSession.setRemoteAddress(inetAddress);
                }
                catch (UnknownHostException e) {
                    this.logger.error("unknown host: " + destAddress, e);
                }
                this.rtpSession.setRemotePort(destPort);
                break;
            }
            case echo: {
                break;
            }
        }
    }

    public void sendDtmf(char digit) {
        if (this.connected()) {
            List<RtpPacket> rtpPackets = this.dtmfFactory.createDtmfPackets(digit);
            RtpSender rtpSender = this.captureRtpSender.getRtpSender();
            rtpSender.pushPackets(rtpPackets);
        }
    }

    public void stopSession() {
        if (this.rtpSession != null) {
            this.rtpSession.stop();
            while (!this.rtpSession.isSocketClosed()) {
                try {
                    Thread.sleep(15L);
                }
                catch (InterruptedException e) {
                    this.logger.debug("sleep interrupted");
                }
            }
            this.rtpSession = null;
        }
        if (this.incomingRtpReader != null) {
            this.incomingRtpReader = null;
        }
        if (this.captureRtpSender != null) {
            this.captureRtpSender.stop();
            this.setCaptureRtpSender(null);
        }
        if (this.datagramSocket != null) {
            this.datagramSocket = null;
        }
        switch (this.userAgent.getMediaMode()) {
            case captureAndPlayback: 
            case file: {
                if (this.soundManager == null) break;
                this.soundManager.close();
                break;
            }
            case echo: {
                Echo echo = this.userAgent.getEcho();
                if (echo == null) break;
                echo.stop();
                this.userAgent.setEcho(null);
                break;
            }
        }
    }

    public void setDatagramSocket(DatagramSocket datagramSocket) {
        this.datagramSocket = datagramSocket;
    }

    public DatagramSocket getDatagramSocket() {
        return this.datagramSocket;
    }

    public SoundSource getSoundSource() {
        switch (this.userAgent.getMediaMode()) {
            case captureAndPlayback: 
            case file: {
                return this.soundManager;
            }
        }
        return null;
    }

    public boolean connected() {
        return this.captureRtpSender != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitConnected() throws InterruptedException {
        if (!this.connected()) {
            Object object = this.connectedSync;
            synchronized (object) {
                while (!this.connected()) {
                    this.connectedSync.wait();
                }
            }
        }
    }

    public void waitFinishedSending() throws IOException, InterruptedException {
        if (this.connected()) {
            this.captureRtpSender.getRtpSender().waitEmpty();
        }
    }
}

