/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.rtp.RtpPacket;
import net.sourceforge.peers.rtp.RtpSession;
import net.sourceforge.peers.sdp.Codec;

public class RtpSender
implements Runnable {
    private static int BUF_SIZE = 160;
    public static int CONSUMING_BYTES_PER_MS = BUF_SIZE / 20;
    private PipedInputStream encodedData;
    private RtpSession rtpSession;
    private boolean isStopped;
    private Object pauseSync;
    private boolean isPaused;
    private FileOutputStream rtpSenderInput;
    private boolean mediaDebug;
    private Codec codec;
    private List<RtpPacket> pushedPackets;
    private Logger logger;
    private String peersHome;
    private CountDownLatch latch;

    public RtpSender(PipedInputStream encodedData, RtpSession rtpSession, boolean mediaDebug, Codec codec, Logger logger, String peersHome, CountDownLatch latch) {
        this.encodedData = encodedData;
        this.rtpSession = rtpSession;
        this.mediaDebug = mediaDebug;
        this.codec = codec;
        this.peersHome = peersHome;
        this.latch = latch;
        this.logger = logger;
        this.isStopped = false;
        this.pauseSync = new Object();
        this.isPaused = false;
        this.pushedPackets = Collections.synchronizedList(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.mediaDebug) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
                String date = simpleDateFormat.format(new Date());
                String fileName = this.peersHome + File.separator + "media" + File.separator + date + "_rtp_sender.input";
                try {
                    this.rtpSenderInput = new FileOutputStream(fileName);
                }
                catch (FileNotFoundException e) {
                    this.logger.error("cannot create file", e);
                    if (this.mediaDebug) {
                        try {
                            this.rtpSenderInput.close();
                        }
                        catch (IOException e2) {
                            this.logger.error("cannot close file", e2);
                            return;
                        }
                    }
                    try {
                        this.encodedData.close();
                    }
                    catch (IOException e3) {
                        this.logger.error("Error closing encoded data input pipe", e3);
                    }
                    this.latch.countDown();
                    if (this.latch.getCount() != 0L) {
                        try {
                            this.latch.await();
                        }
                        catch (InterruptedException e4) {
                            this.logger.error("interrupt exception", e4);
                        }
                    }
                    return;
                }
            }
            RtpPacket rtpPacket = new RtpPacket();
            rtpPacket.setVersion(2);
            rtpPacket.setPadding(false);
            rtpPacket.setExtension(false);
            rtpPacket.setCsrcCount(0);
            rtpPacket.setMarker(false);
            rtpPacket.setPayloadType(this.codec.getPayloadType());
            Random random = new Random();
            int sequenceNumber = random.nextInt();
            rtpPacket.setSequenceNumber(sequenceNumber);
            rtpPacket.setSsrc(random.nextInt());
            byte[] buffer = new byte[BUF_SIZE];
            byte[] pauseBuffer = new byte[BUF_SIZE];
            Arrays.fill(pauseBuffer, this.silenceByte(this.codec));
            int timestamp = 0;
            int numBytesRead = 0;
            boolean currentlyReading = false;
            long sleepTime = 0L;
            long lastSentTime = System.nanoTime();
            boolean firstTime = true;
            int sleeps = 0;
            long sumOversleep = 0L;
            long avgOversleep = 0L;
            while (!this.isStopped || this.encodedDataAvailable() > 0 || this.pushedPackets.size() > 0) {
                if (this.pushedPackets.size() > 0) {
                    RtpPacket pushedPacket = this.pushedPackets.remove(0);
                    rtpPacket.setMarker(pushedPacket.isMarker());
                    rtpPacket.setPayloadType(pushedPacket.getPayloadType());
                    rtpPacket.setIncrementTimeStamp(pushedPacket.isIncrementTimeStamp());
                    byte[] data = pushedPacket.getData();
                    rtpPacket.setData(data);
                } else {
                    byte[] trimmedBuffer;
                    block68: {
                        if (!currentlyReading) {
                            numBytesRead = 0;
                        }
                        try {
                            if (this.isPaused) {
                                Object pushedPacket = this.pauseSync;
                                synchronized (pushedPacket) {
                                    if (this.isPaused) {
                                        try {
                                            this.pauseSync.wait(5000L);
                                        }
                                        catch (InterruptedException e) {
                                            this.logger.error("Interrupted pausing");
                                            break;
                                        }
                                    }
                                }
                            }
                            if (this.isPaused) {
                                System.arraycopy(pauseBuffer, 0, buffer, 0, BUF_SIZE);
                                numBytesRead = BUF_SIZE;
                            } else {
                                while (numBytesRead < BUF_SIZE && this.encodedDataAvailable() > 0) {
                                    int tempBytesRead = this.encodedData.read(buffer, numBytesRead, BUF_SIZE - numBytesRead);
                                    if (tempBytesRead < 0) {
                                        this.setStopped(true);
                                        break;
                                    }
                                    numBytesRead += tempBytesRead;
                                }
                                currentlyReading = numBytesRead > 0 && numBytesRead < BUF_SIZE;
                            }
                        }
                        catch (IOException e) {
                            if (this.isStopped) break block68;
                            this.logger.error("Error reading encoded data", e);
                        }
                    }
                    if (currentlyReading) continue;
                    if (numBytesRead < buffer.length) {
                        trimmedBuffer = new byte[numBytesRead];
                        System.arraycopy(buffer, 0, trimmedBuffer, 0, numBytesRead);
                    } else {
                        trimmedBuffer = buffer;
                    }
                    if (this.mediaDebug) {
                        try {
                            this.rtpSenderInput.write(trimmedBuffer);
                        }
                        catch (IOException e) {
                            this.logger.error("cannot write to file", e);
                        }
                    }
                    if (rtpPacket.getPayloadType() != this.codec.getPayloadType()) {
                        rtpPacket.setPayloadType(this.codec.getPayloadType());
                        rtpPacket.setMarker(false);
                    }
                    rtpPacket.setData(trimmedBuffer);
                }
                rtpPacket.setSequenceNumber(sequenceNumber++);
                if (rtpPacket.isIncrementTimeStamp()) {
                    timestamp += BUF_SIZE;
                }
                rtpPacket.setTimestamp(timestamp);
                if (firstTime) {
                    lastSentTime = System.nanoTime();
                    this.rtpSession.send(rtpPacket);
                    firstTime = false;
                    continue;
                }
                long beforeSleep = System.nanoTime();
                sleepTime = 20000000L - (beforeSleep - lastSentTime) - avgOversleep;
                if (sleepTime > 0L) {
                    try {
                        Thread.sleep(sleepTime / 1000000L, (int)sleepTime % 1000000);
                    }
                    catch (InterruptedException e) {
                        this.logger.error("Thread interrupted", e);
                        if (this.mediaDebug) {
                            try {
                                this.rtpSenderInput.close();
                            }
                            catch (IOException e5) {
                                this.logger.error("cannot close file", e5);
                                return;
                            }
                        }
                        try {
                            this.encodedData.close();
                        }
                        catch (IOException e6) {
                            this.logger.error("Error closing encoded data input pipe", e6);
                        }
                        this.latch.countDown();
                        if (this.latch.getCount() != 0L) {
                            try {
                                this.latch.await();
                            }
                            catch (InterruptedException e7) {
                                this.logger.error("interrupt exception", e7);
                            }
                        }
                        return;
                    }
                    lastSentTime = System.nanoTime();
                    long slept = lastSentTime - beforeSleep;
                    long oversleep = slept - sleepTime;
                    sumOversleep += oversleep;
                    if (sleeps++ == 10) {
                        avgOversleep = sumOversleep / (long)sleeps;
                        sleeps = 0;
                        sumOversleep = 0L;
                    }
                    this.rtpSession.send(rtpPacket);
                    continue;
                }
                lastSentTime = System.nanoTime();
                this.rtpSession.send(rtpPacket);
            }
        }
        finally {
            if (this.mediaDebug) {
                try {
                    this.rtpSenderInput.close();
                }
                catch (IOException e) {
                    this.logger.error("cannot close file", e);
                    return;
                }
            }
            try {
                this.encodedData.close();
            }
            catch (IOException e) {
                this.logger.error("Error closing encoded data input pipe", e);
            }
            this.latch.countDown();
            if (this.latch.getCount() != 0L) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException e) {
                    this.logger.error("interrupt exception", e);
                }
            }
        }
    }

    public void setStopped(boolean isStopped) {
        this.isStopped = isStopped;
        this.resume();
    }

    public void pause() {
        this.isPaused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resume() {
        this.isPaused = false;
        Object object = this.pauseSync;
        synchronized (object) {
            this.pauseSync.notifyAll();
        }
    }

    public void waitEmpty() throws IOException, InterruptedException {
        while (this.encodedData.available() > 0) {
            Thread.sleep(5L);
        }
    }

    public void pushPackets(List<RtpPacket> rtpPackets) {
        this.pushedPackets.addAll(rtpPackets);
    }

    private int encodedDataAvailable() {
        try {
            return this.encodedData.available();
        }
        catch (IOException e) {
            this.logger.error("Error getting amount available encoded data. Should never happen", e);
            return 0;
        }
    }

    private byte silenceByte(Codec codec) {
        switch (codec.getPayloadType()) {
            case 8: {
                return -43;
            }
            case 0: {
                return -1;
            }
        }
        return 0;
    }
}

