/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

public interface SoundSource {
    default public DataFormat dataProduced() {
        return DataFormat.DEFAULT;
    }

    public byte[] readData();

    default public boolean finished() {
        return false;
    }

    default public void waitFinished() throws InterruptedException {
        throw new RuntimeException("Waiting for finished not supported");
    }

    public static enum DataFormat {
        LINEAR_PCM_8KHZ_16BITS_SIGNED_MONO_LITTLE_ENDIAN("pcm_8khz_16_bits_mono", "Linear PCM, 8kHz, 16-bites signed, mono-channel, little endian"),
        ALAW_8KHZ_MONO_LITTLE_ENDIAN("a_law", "A-law, 8kHz, mono-channel, little endian");

        private String shortAlias;
        private String description;
        public static DataFormat DEFAULT;

        private DataFormat(String shortAlias, String description) {
            this.shortAlias = shortAlias;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getShortAlias() {
            return this.shortAlias;
        }

        public static DataFormat fromShortAlias(String shortAlias) {
            for (DataFormat df : DataFormat.values()) {
                if (!df.shortAlias.equals(shortAlias)) continue;
                return df;
            }
            return null;
        }

        static {
            DEFAULT = LINEAR_PCM_8KHZ_16BITS_SIGNED_MONO_LITTLE_ENDIAN;
        }
    }
}

