/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sdp;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.List;
import net.sourceforge.peers.sdp.MediaDescription;

public class SessionDescription {
    private long id;
    private long version;
    private String name;
    private String username;
    private InetAddress ipAddress;
    private List<MediaDescription> mediaDescriptions;
    private Hashtable<String, String> attributes;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(InetAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    public List<MediaDescription> getMediaDescriptions() {
        return this.mediaDescriptions;
    }

    public void setMediaDescriptions(List<MediaDescription> mediaDescriptions) {
        this.mediaDescriptions = mediaDescriptions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public Hashtable<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Hashtable<String, String> attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        int ipVersion;
        StringBuffer buf = new StringBuffer();
        buf.append("v=0\r\n");
        buf.append("o=").append(this.username).append(" ").append(this.id);
        buf.append(" ").append(this.version);
        if (this.ipAddress instanceof Inet4Address) {
            ipVersion = 4;
        } else if (this.ipAddress instanceof Inet6Address) {
            ipVersion = 6;
        } else {
            throw new RuntimeException("unknown ip version: " + this.ipAddress);
        }
        buf.append(" IN IP").append(ipVersion).append(" ");
        String hostAddress = this.ipAddress.getHostAddress();
        buf.append(hostAddress).append("\r\n");
        buf.append("s=").append(this.name).append("\r\n");
        buf.append("c=IN IP").append(ipVersion).append(" ");
        buf.append(hostAddress).append("\r\n");
        buf.append("t=0 0\r\n");
        for (String attributeName : this.attributes.keySet()) {
            String attributeValue = this.attributes.get(attributeName);
            buf.append("a=").append(attributeName);
            if (attributeValue == null || "".equals(attributeValue.trim())) continue;
            buf.append(":");
            buf.append(attributeValue);
            buf.append("\r\n");
        }
        for (MediaDescription mediaDescription : this.mediaDescriptions) {
            buf.append(mediaDescription.toString());
        }
        return buf.toString();
    }
}

