/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.core.useragent.handlers;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.TimerTask;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.Timer;
import net.sourceforge.peers.sip.core.useragent.InitialRequestManager;
import net.sourceforge.peers.sip.core.useragent.RequestManager;
import net.sourceforge.peers.sip.core.useragent.SipListener;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.core.useragent.handlers.MethodHandler;
import net.sourceforge.peers.sip.syntaxencoding.NameAddress;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.syntaxencoding.SipURI;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import net.sourceforge.peers.sip.transaction.ClientTransaction;
import net.sourceforge.peers.sip.transaction.ClientTransactionUser;
import net.sourceforge.peers.sip.transaction.NonInviteClientTransaction;
import net.sourceforge.peers.sip.transaction.Transaction;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.TransportManager;

public class RegisterHandler
extends MethodHandler
implements ClientTransactionUser {
    public static final int REFRESH_MARGIN = 10;
    private InitialRequestManager initialRequestManager;
    private Timer timer;
    private String requestUriStr;
    private String profileUriStr;
    private String callIDStr;
    private boolean unregisterInvoked;
    private boolean registered;

    public RegisterHandler(UserAgent userAgent, TransactionManager transactionManager, TransportManager transportManager, Logger logger) {
        super(userAgent, transactionManager, transportManager, logger);
    }

    public synchronized ClientTransaction preProcessRegister(SipRequest sipRequest) throws SipUriSyntaxException {
        InetAddress inetAddress;
        SipURI sipUri;
        String reqUriTransport;
        this.registered = false;
        this.unregisterInvoked = false;
        SipHeaders sipHeaders = sipRequest.getSipHeaders();
        SipURI destinationUri = RequestManager.getDestinationUri(sipRequest, this.logger);
        int port = destinationUri.getPort();
        if (port == -1) {
            port = 5060;
        }
        String transport = "UDP";
        Hashtable<String, String> params = destinationUri.getUriParameters();
        if (params != null && (reqUriTransport = params.get("transport")) != null) {
            transport = reqUriTransport;
        }
        if ((sipUri = this.userAgent.getConfig().getOutboundProxy()) == null) {
            sipUri = destinationUri;
        }
        try {
            inetAddress = InetAddress.getByName(sipUri.getHost());
        }
        catch (UnknownHostException e) {
            throw new SipUriSyntaxException("unknown host: " + sipUri.getHost(), e);
        }
        ClientTransaction clientTransaction = this.transactionManager.createClientTransaction(sipRequest, inetAddress, port, transport, null, this);
        SipHeaderFieldValue to = sipHeaders.get(new SipHeaderFieldName("To"));
        SipHeaderFieldValue from = sipHeaders.get(new SipHeaderFieldName("From"));
        String fromValue = from.getValue();
        to.setValue(fromValue);
        this.requestUriStr = destinationUri.toString();
        this.profileUriStr = NameAddress.nameAddressToUri(fromValue);
        this.callIDStr = sipHeaders.get(new SipHeaderFieldName("Call-ID")).toString();
        sipHeaders.add(new SipHeaderFieldName("Expires"), new SipHeaderFieldValue(String.valueOf(3600)));
        return clientTransaction;
    }

    public void unregister() {
        this.timer.cancel();
        this.unregisterInvoked = true;
        this.challenged = false;
    }

    @Override
    public void errResponseReceived(SipResponse sipResponse) {
        String password = this.userAgent.getConfig().getPassword();
        if (password != null && !"".equals(password.trim())) {
            int statusCode = sipResponse.getStatusCode();
            if (statusCode == 401 || statusCode == 407) {
                if (this.challenged) {
                    this.notifyListener(sipResponse);
                } else {
                    this.challenged = true;
                    NonInviteClientTransaction nonInviteClientTransaction = (NonInviteClientTransaction)this.transactionManager.getClientTransaction(sipResponse);
                    SipRequest sipRequest = nonInviteClientTransaction.getRequest();
                    this.challengeManager.handleChallenge(sipRequest, sipResponse);
                }
            } else {
                String received;
                SipHeaders sipHeaders = sipResponse.getSipHeaders();
                SipHeaderFieldName viaName = new SipHeaderFieldName("Via");
                SipHeaderFieldValue via = sipHeaders.get(viaName);
                SipHeaderParamName receivedName = new SipHeaderParamName("received");
                String viaValue = via.getValue();
                int pos = viaValue.indexOf(" ");
                if (pos > -1) {
                    if ((pos = (viaValue = viaValue.substring(pos + 1)).indexOf(58)) > -1) {
                        viaValue = viaValue.substring(0, pos);
                    } else {
                        pos = viaValue.indexOf(";");
                        if (pos > -1) {
                            viaValue = viaValue.substring(0, pos);
                        }
                    }
                }
                if ((received = via.getParam(receivedName)) != null && !"".equals(received.trim())) {
                    if (viaValue.equals(received)) {
                        this.notifyListener(sipResponse);
                    } else {
                        try {
                            InetAddress receivedInetAddress = InetAddress.getByName(received);
                            Config config = this.userAgent.getConfig();
                            config.setPublicInetAddress(receivedInetAddress);
                            this.userAgent.register();
                        }
                        catch (UnknownHostException e) {
                            this.notifyListener(sipResponse);
                            this.logger.error(e.getMessage(), e);
                        }
                        catch (SipUriSyntaxException e) {
                            this.notifyListener(sipResponse);
                            this.logger.error(e.getMessage(), e);
                        }
                    }
                } else {
                    this.notifyListener(sipResponse);
                }
            }
        } else {
            this.notifyListener(sipResponse);
        }
    }

    private void notifyListener(SipResponse sipResponse) {
        SipListener sipListener = this.userAgent.getSipListener();
        if (sipListener != null) {
            sipListener.registerFailed(sipResponse);
        }
        this.challenged = false;
    }

    @Override
    public void provResponseReceived(SipResponse sipResponse, Transaction transaction) {
    }

    @Override
    public synchronized void successResponseReceived(SipResponse sipResponse, Transaction transaction) {
        SipListener sipListener;
        SipRequest sipRequest = transaction.getRequest();
        SipHeaderFieldName contactName = new SipHeaderFieldName("Contact");
        SipHeaderFieldValue requestContact = sipRequest.getSipHeaders().get(contactName);
        SipHeaderParamName expiresParam = new SipHeaderParamName("expires");
        String expires = requestContact.getParam(expiresParam);
        this.challenged = false;
        if (!"0".equals(expires)) {
            SipHeaders sipHeaders = sipResponse.getSipHeaders();
            SipHeaderFieldValue responseContact = sipHeaders.get(contactName);
            if (responseContact == null) {
                return;
            }
            expires = responseContact.getParam(expiresParam);
            this.registered = true;
            int delay = -1;
            if (expires == null || "".equals(expires.trim())) {
                delay = 3600;
            }
            if (!this.unregisterInvoked) {
                if (delay == -1) {
                    delay = Integer.parseInt(expires) - 10;
                }
                if (this.timer != null) {
                    this.timer.cancel();
                }
                this.timer = new Timer(this.getClass().getSimpleName() + " refresh timer");
                this.timer.schedule((TimerTask)new RefreshTimerTask(), delay * 1000);
            }
        }
        if ((sipListener = this.userAgent.getSipListener()) != null) {
            sipListener.registerSuccessful(sipResponse);
        }
    }

    @Override
    public void transactionTimeout(ClientTransaction clientTransaction) {
        SipListener sipListener = this.userAgent.getSipListener();
        if (sipListener != null) {
            sipListener.registerFailed(null);
        }
    }

    @Override
    public void transactionTransportError() {
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setInitialRequestManager(InitialRequestManager initialRequestManager) {
        this.initialRequestManager = initialRequestManager;
    }

    class RefreshTimerTask
    extends TimerTask {
        RefreshTimerTask() {
        }

        @Override
        public void run() {
            try {
                RegisterHandler.this.initialRequestManager.createInitialRequest(RegisterHandler.this.requestUriStr, "REGISTER", RegisterHandler.this.profileUriStr, RegisterHandler.this.callIDStr);
            }
            catch (SipUriSyntaxException e) {
                RegisterHandler.this.logger.error("syntax error", e);
            }
        }
    }
}

