/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.syntaxencoding;

import java.util.HashMap;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;

public class SipHeaderFieldValue {
    private String value;
    private HashMap<SipHeaderParamName, String> params;

    public SipHeaderFieldValue(String value) {
        String[] arr;
        String paramsString;
        int startPos = value.indexOf(62);
        int pos = startPos > -1 ? value.indexOf(";", startPos) : value.indexOf(";");
        if (pos > -1) {
            this.value = value.substring(0, pos);
            paramsString = value.substring(pos);
        } else {
            this.value = value;
            paramsString = "";
        }
        this.params = new HashMap();
        if (paramsString.contains(";") && (arr = paramsString.split(";")).length > 1) {
            for (int i = 1; i < arr.length; ++i) {
                String paramName = arr[i];
                String paramValue = "";
                pos = paramName.indexOf("=");
                if (pos > -1) {
                    paramName = arr[i].substring(0, pos);
                    paramValue = arr[i].substring(pos + 1);
                }
                this.params.put(new SipHeaderParamName(paramName), paramValue);
            }
        }
    }

    public String getParam(SipHeaderParamName name) {
        return this.params.get(name);
    }

    public void addParam(SipHeaderParamName name, String value) {
        this.params.put(name, value);
    }

    public void removeParam(SipHeaderParamName name) {
        this.params.remove(name);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        if (this.params == null || this.params.isEmpty()) {
            return this.value;
        }
        StringBuffer buf = new StringBuffer(this.value);
        for (SipHeaderParamName name : this.params.keySet()) {
            buf.append(";").append(name);
            String value = this.params.get(name);
            if ("".equals(value.trim())) continue;
            buf.append("=").append(value);
        }
        return buf.toString();
    }
}

