/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.syntaxencoding;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldMultiValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.syntaxencoding.SipParserException;
import net.sourceforge.peers.sip.syntaxencoding.SipURI;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import net.sourceforge.peers.sip.transport.SipMessage;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;

public class SipParser {
    private BufferedReader reader;
    private static final int BUFF_SIZE = 1024;
    private List<SipHeaderFieldName> singleValueHeaders = new ArrayList<SipHeaderFieldName>();

    public SipParser() {
        this.singleValueHeaders.add(new SipHeaderFieldName("WWW-Authenticate"));
        this.singleValueHeaders.add(new SipHeaderFieldName("Authorization"));
        this.singleValueHeaders.add(new SipHeaderFieldName("Proxy-Authenticate"));
        this.singleValueHeaders.add(new SipHeaderFieldName("Proxy-Authorization"));
        this.singleValueHeaders.add(new SipHeaderFieldName("Supported"));
        this.singleValueHeaders.add(new SipHeaderFieldName("Subject"));
    }

    public synchronized SipMessage parse(InputStream in) throws IOException, SipParserException {
        InputStreamReader inputStreamReader = new InputStreamReader(in);
        this.reader = new BufferedReader(inputStreamReader);
        String startLine = this.reader.readLine();
        while (startLine == null || startLine.equals("")) {
            startLine = this.reader.readLine();
        }
        SipMessage sipMessage = startLine.toUpperCase().startsWith("SIP/2.0") ? this.parseSipResponse(startLine) : this.parseSipRequest(startLine);
        this.parseHeaders(sipMessage);
        this.parseBody(sipMessage);
        return sipMessage;
    }

    private SipRequest parseSipRequest(String startLine) throws SipParserException {
        SipURI requestUri;
        String[] params = startLine.split(" ");
        if (params.length != 3) {
            throw new SipParserException("invalid request line");
        }
        if (!"SIP/2.0".equals(params[2].toUpperCase())) {
            throw new SipParserException("unsupported SIP version");
        }
        try {
            requestUri = new SipURI(params[1]);
        }
        catch (SipUriSyntaxException e) {
            throw new SipParserException(e);
        }
        return new SipRequest(params[0], requestUri);
    }

    private SipResponse parseSipResponse(String startLine) throws SipParserException {
        String[] params = startLine.split(" ");
        if (params.length < 3) {
            throw new SipParserException("incorrect status line");
        }
        if (!"SIP/2.0".equals(params[0].toUpperCase())) {
            throw new SipParserException("unsupported SIP version");
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 2; i < params.length; ++i) {
            buf.append(params[i]).append(" ");
        }
        buf.deleteCharAt(buf.length() - 1);
        return new SipResponse(Integer.parseInt(params[1]), buf.toString());
    }

    private void parseHeaders(SipMessage sipMessage) throws IOException, SipParserException {
        SipHeaders sipHeaders = new SipHeaders();
        String headerLine = this.reader.readLine();
        if (headerLine == null) {
            throw new SipParserException(sipMessage.toString());
        }
        while (!"".equals(headerLine)) {
            SipHeaderFieldValue sipHeaderValue;
            String nextLine = this.reader.readLine();
            if (nextLine != null && (nextLine.startsWith(" ") || nextLine.startsWith("\t"))) {
                StringBuffer buf = new StringBuffer(headerLine);
                while (nextLine != null && (nextLine.startsWith(" ") || nextLine.startsWith("\t"))) {
                    buf.append(' ');
                    buf.append(nextLine.trim());
                    nextLine = this.reader.readLine();
                }
                headerLine = buf.toString();
            }
            if (headerLine == null) {
                throw new SipParserException(sipMessage.toString());
            }
            int columnPos = headerLine.indexOf(58);
            if (columnPos < 0) {
                throw new SipParserException("Invalid header line");
            }
            SipHeaderFieldName sipHeaderName = new SipHeaderFieldName(headerLine.substring(0, columnPos).trim());
            String value = headerLine.substring(columnPos + 1).trim();
            if (!this.singleValueHeaders.contains(sipHeaderName) && value.indexOf(",") > -1) {
                String[] values = value.split(",");
                ArrayList<SipHeaderFieldValue> list = new ArrayList<SipHeaderFieldValue>();
                for (String s : values) {
                    list.add(new SipHeaderFieldValue(s));
                }
                sipHeaderValue = new SipHeaderFieldMultiValue(list);
            } else {
                sipHeaderValue = new SipHeaderFieldValue(value);
            }
            sipHeaders.add(sipHeaderName, sipHeaderValue);
            headerLine = nextLine;
        }
        sipMessage.setSipHeaders(sipHeaders);
    }

    public void parseBody(SipMessage sipMessage) throws IOException, SipParserException {
        byte[] aux;
        int i;
        SipHeaderFieldValue contentLengthValue = sipMessage.getSipHeaders().get(new SipHeaderFieldName("Content-Length"));
        if (contentLengthValue == null) {
            return;
        }
        int length = Integer.parseInt(contentLengthValue.toString());
        byte[] buff = new byte[1024];
        int count = 0;
        while (count < length && (i = this.reader.read()) != -1) {
            if (count >= buff.length) {
                aux = new byte[buff.length + 1024];
                System.arraycopy(buff, 0, aux, 0, buff.length);
                buff = aux;
            }
            buff[count++] = (byte)i;
        }
        if (count != buff.length) {
            aux = new byte[count];
            System.arraycopy(buff, 0, aux, 0, count);
            buff = aux;
        }
        sipMessage.setBody(buff);
    }
}

