/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transaction;

import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.transaction.NonInviteClientTransaction;
import net.sourceforge.peers.sip.transaction.NonInviteClientTransactionState;
import net.sourceforge.peers.sip.transport.SipResponse;

public class NonInviteClientTransactionStateTrying
extends NonInviteClientTransactionState {
    public NonInviteClientTransactionStateTrying(String id, NonInviteClientTransaction nonInviteClientTransaction, Logger logger) {
        super(id, nonInviteClientTransaction, logger);
    }

    @Override
    public void timerEFires() {
        NonInviteClientTransactionState nextState = this.nonInviteClientTransaction.TRYING;
        this.nonInviteClientTransaction.setState(nextState);
        long delay = (long)Math.pow(2.0, ++this.nonInviteClientTransaction.nbRetrans) * 500L;
        this.nonInviteClientTransaction.sendRetrans(Math.min(delay, 4000L));
    }

    @Override
    public void timerFFires() {
        this.timerFFiresOrTransportError();
    }

    @Override
    public void transportError() {
        this.timerFFiresOrTransportError();
    }

    private void timerFFiresOrTransportError() {
        NonInviteClientTransactionState nextState = this.nonInviteClientTransaction.TERMINATED;
        this.nonInviteClientTransaction.setState(nextState);
        this.nonInviteClientTransaction.transactionUser.transactionTimeout(this.nonInviteClientTransaction);
    }

    @Override
    public void received1xx() {
        NonInviteClientTransactionState nextState = this.nonInviteClientTransaction.PROCEEDING;
        this.nonInviteClientTransaction.setState(nextState);
        this.nonInviteClientTransaction.transactionUser.provResponseReceived(this.nonInviteClientTransaction.getLastResponse(), this.nonInviteClientTransaction);
    }

    @Override
    public void received200To699() {
        NonInviteClientTransactionState nextState = this.nonInviteClientTransaction.COMPLETED;
        this.nonInviteClientTransaction.setState(nextState);
        SipResponse response = this.nonInviteClientTransaction.getLastResponse();
        int code = response.getStatusCode();
        if (code < 300) {
            this.nonInviteClientTransaction.transactionUser.successResponseReceived(response, this.nonInviteClientTransaction);
        } else {
            this.nonInviteClientTransaction.transactionUser.errResponseReceived(response);
        }
    }
}

