/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transport;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.Utils;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.syntaxencoding.SipParser;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transport.MessageReceiver;
import net.sourceforge.peers.sip.transport.MessageSender;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.SipServerTransportUser;
import net.sourceforge.peers.sip.transport.SipTransportConnection;
import net.sourceforge.peers.sip.transport.UdpMessageReceiver;
import net.sourceforge.peers.sip.transport.UdpMessageSender;

public class TransportManager {
    public static final int SOCKET_TIMEOUT = 500;
    private static int NO_TTL = -1;
    private Logger logger;
    private SipServerTransportUser sipServerTransportUser;
    protected SipParser sipParser = new SipParser();
    private Hashtable<SipTransportConnection, DatagramSocket> datagramSockets = new Hashtable();
    private Hashtable<SipTransportConnection, MessageSender> messageSenders = new Hashtable();
    private Hashtable<SipTransportConnection, MessageReceiver> messageReceivers = new Hashtable();
    private TransactionManager transactionManager;
    private Config config;
    private int sipPort;

    public TransportManager(TransactionManager transactionManager, Config config, Logger logger) {
        this.transactionManager = transactionManager;
        this.config = config;
        this.logger = logger;
    }

    public MessageSender createClientTransport(SipRequest sipRequest, InetAddress inetAddress, int port, String transport) throws IOException {
        return this.createClientTransport(sipRequest, inetAddress, port, transport, NO_TTL);
    }

    public MessageSender createClientTransport(SipRequest sipRequest, InetAddress inetAddress, int port, String transport, int ttl) throws IOException {
        SipHeaderFieldValue via = Utils.getTopVia(sipRequest);
        StringBuffer buf = new StringBuffer("SIP/2.0");
        buf.append('/');
        if (sipRequest.toString().getBytes().length > 1300) {
            transport = "TCP";
        }
        buf.append(transport);
        if (inetAddress.isMulticastAddress()) {
            SipHeaderParamName maddrName = new SipHeaderParamName("maddr");
            via.addParam(maddrName, inetAddress.getHostAddress());
            if (inetAddress instanceof Inet4Address) {
                SipHeaderParamName ttlName = new SipHeaderParamName("ttl");
                via.addParam(ttlName, "1");
            }
        }
        via.addParam(new SipHeaderParamName("rport"), "");
        buf.append(' ');
        InetAddress myAddress = this.config.getPublicInetAddress();
        if (myAddress == null) {
            myAddress = this.config.getLocalInetAddress();
        }
        buf.append(myAddress.getHostAddress());
        buf.append(':');
        if (this.sipPort < 1) {
            if ("TCP".equals(transport) || "UDP".equals(transport) || "SCTP".equals(transport)) {
                this.sipPort = 5060;
            } else if ("SCTP".equals(transport)) {
                this.sipPort = 5061;
            } else {
                throw new RuntimeException("unknown transport type");
            }
        }
        buf.append(this.sipPort);
        via.setValue(buf.toString());
        SipTransportConnection connection = new SipTransportConnection(this.config.getLocalInetAddress(), this.sipPort, inetAddress, port, transport);
        MessageSender messageSender = this.messageSenders.get(connection);
        if (messageSender == null) {
            messageSender = this.createMessageSender(connection);
        }
        return messageSender;
    }

    private String threadName(int port) {
        return this.getClass().getSimpleName() + " " + port;
    }

    public void createServerTransport(String transportType, int port) throws SocketException {
        SipTransportConnection conn = new SipTransportConnection(this.config.getLocalInetAddress(), port, null, -1, transportType);
        MessageReceiver messageReceiver = this.messageReceivers.get(conn);
        if (messageReceiver == null) {
            messageReceiver = this.createMessageReceiver(conn);
            new Thread((Runnable)messageReceiver, this.threadName(port)).start();
        }
        if (!messageReceiver.isListening()) {
            new Thread((Runnable)messageReceiver, this.threadName(port)).start();
        }
    }

    public void sendResponse(SipResponse sipResponse) throws IOException {
        SipTransportConnection connection;
        String rport;
        String transport;
        int port;
        String host;
        SipHeaderFieldValue topVia = Utils.getTopVia(sipResponse);
        String topViaValue = topVia.getValue();
        StringBuffer buf = new StringBuffer(topViaValue);
        String hostport = null;
        for (int i = topViaValue.length() - 1; i > 0; --i) {
            char c = buf.charAt(i);
            if (c != ' ' && c != '\t') continue;
            hostport = buf.substring(i + 1);
            break;
        }
        if (hostport == null) {
            throw new RuntimeException("host or ip address not found in top via");
        }
        int colonPos = hostport.indexOf(58);
        if (colonPos > -1) {
            host = hostport.substring(0, colonPos);
            port = Integer.parseInt(hostport.substring(colonPos + 1, hostport.length()));
        } else {
            host = hostport;
            port = 5060;
        }
        if (buf.indexOf("TCP") > -1) {
            transport = "TCP";
        } else if (buf.indexOf("UDP") > -1) {
            transport = "UDP";
        } else {
            this.logger.error("no transport found in top via header, discarding response");
            return;
        }
        String received = topVia.getParam(new SipHeaderParamName("received"));
        if (received != null) {
            host = received;
        }
        if ((rport = topVia.getParam(new SipHeaderParamName("rport"))) != null && !"".equals(rport.trim())) {
            port = Integer.parseInt(rport);
        }
        try {
            connection = new SipTransportConnection(this.config.getLocalInetAddress(), this.sipPort, InetAddress.getByName(host), port, transport);
        }
        catch (UnknownHostException e) {
            this.logger.error("unknwon host", e);
            return;
        }
        if (buf.indexOf("TCP") <= -1) {
            MessageSender messageSender = this.messageSenders.get(connection);
            if (messageSender == null) {
                messageSender = this.createMessageSender(connection);
            }
            SipHeaderFieldName contactName = new SipHeaderFieldName("Contact");
            SipHeaders respHeaders = sipResponse.getSipHeaders();
            StringBuffer contactBuf = new StringBuffer();
            contactBuf.append('<');
            contactBuf.append("sip");
            contactBuf.append(':');
            contactBuf.append(messageSender.getContact());
            contactBuf.append('>');
            respHeaders.add(contactName, new SipHeaderFieldValue(contactBuf.toString()));
            messageSender.sendMessage(sipResponse);
        }
    }

    private MessageSender createMessageSender(final SipTransportConnection conn) throws IOException {
        UdpMessageSender messageSender = null;
        DatagramSocket socket = null;
        if ("UDP".equalsIgnoreCase(conn.getTransport())) {
            DatagramSocket datagramSocket = this.datagramSockets.get(conn);
            if (datagramSocket == null) {
                this.logger.debug("new DatagramSocket(" + conn.getLocalPort() + ", " + conn.getLocalInetAddress() + ")");
                datagramSocket = AccessController.doPrivileged(new PrivilegedAction<DatagramSocket>(){

                    @Override
                    public DatagramSocket run() {
                        try {
                            return new DatagramSocket(conn.getLocalPort(), conn.getLocalInetAddress());
                        }
                        catch (SocketException e) {
                            TransportManager.this.logger.error("cannot create socket", e);
                        }
                        catch (SecurityException e) {
                            TransportManager.this.logger.error("security exception", e);
                        }
                        return null;
                    }
                });
                if (datagramSocket == null) {
                    throw new SocketException();
                }
                datagramSocket.setSoTimeout(500);
                this.datagramSockets.put(conn, datagramSocket);
                this.logger.info("added datagram socket " + conn);
            }
            socket = datagramSocket;
            messageSender = new UdpMessageSender(conn.getRemoteInetAddress(), conn.getRemotePort(), datagramSocket, this.config, this.logger);
        }
        this.messageSenders.put(conn, messageSender);
        MessageReceiver messageReceiver = this.messageReceivers.get(conn);
        if (messageReceiver == null) {
            messageReceiver = this.createMessageReceiver(conn, socket);
            new Thread((Runnable)messageReceiver, this.threadName(conn.getLocalPort())).start();
        }
        return messageSender;
    }

    private MessageReceiver createMessageReceiver(SipTransportConnection conn, Object socket) throws IOException {
        UdpMessageReceiver messageReceiver = null;
        if ("UDP".equalsIgnoreCase(conn.getTransport())) {
            DatagramSocket datagramSocket = (DatagramSocket)socket;
            messageReceiver = new UdpMessageReceiver(datagramSocket, this.transactionManager, this, this.config, this.logger);
            messageReceiver.setSipServerTransportUser(this.sipServerTransportUser);
        }
        this.messageReceivers.put(conn, messageReceiver);
        return messageReceiver;
    }

    private MessageReceiver createMessageReceiver(final SipTransportConnection conn) throws SocketException {
        UdpMessageReceiver messageReceiver = null;
        SipTransportConnection sipTransportConnection = conn;
        if ("UDP".equals(conn.getTransport())) {
            DatagramSocket datagramSocket = this.datagramSockets.get(conn);
            if (datagramSocket == null) {
                this.logger.debug("new DatagramSocket(" + conn.getLocalPort() + ", " + conn.getLocalInetAddress() + ")");
                datagramSocket = AccessController.doPrivileged(new PrivilegedAction<DatagramSocket>(){

                    @Override
                    public DatagramSocket run() {
                        try {
                            return new DatagramSocket(conn.getLocalPort(), conn.getLocalInetAddress());
                        }
                        catch (SocketException e) {
                            TransportManager.this.logger.error("cannot create socket", e);
                        }
                        catch (SecurityException e) {
                            TransportManager.this.logger.error("security exception", e);
                        }
                        return null;
                    }
                });
                datagramSocket.setSoTimeout(500);
                if (conn.getLocalPort() == 0) {
                    sipTransportConnection = new SipTransportConnection(conn.getLocalInetAddress(), datagramSocket.getLocalPort(), conn.getRemoteInetAddress(), conn.getRemotePort(), conn.getTransport());
                }
                this.sipPort = datagramSocket.getLocalPort();
                this.datagramSockets.put(sipTransportConnection, datagramSocket);
                this.logger.info("added datagram socket " + sipTransportConnection);
            }
            messageReceiver = new UdpMessageReceiver(datagramSocket, this.transactionManager, this, this.config, this.logger);
            messageReceiver.setSipServerTransportUser(this.sipServerTransportUser);
        }
        this.messageReceivers.put(sipTransportConnection, messageReceiver);
        this.logger.info("added " + sipTransportConnection + ": " + messageReceiver + " to message receivers");
        return messageReceiver;
    }

    public void setSipServerTransportUser(SipServerTransportUser sipServerTransportUser) {
        this.sipServerTransportUser = sipServerTransportUser;
    }

    public void closeTransports() {
        for (MessageReceiver messageReceiver : this.messageReceivers.values()) {
            messageReceiver.setListening(false);
        }
        for (MessageSender messageSender : this.messageSenders.values()) {
            messageSender.stopKeepAlives();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                for (DatagramSocket datagramSocket : TransportManager.this.datagramSockets.values()) {
                    datagramSocket.close();
                }
                return null;
            }
        });
        this.datagramSockets.clear();
        this.messageReceivers.clear();
        this.messageSenders.clear();
    }

    public MessageSender getMessageSender(SipTransportConnection sipTransportConnection) {
        return this.messageSenders.get(sipTransportConnection);
    }

    public int getSipPort() {
        return this.sipPort;
    }

    public void setSipPort(int sipPort) {
        this.sipPort = sipPort;
    }
}

