/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.SoundSource;

public class FileReader
implements SoundSource {
    public static final int BUFFER_SIZE = 256;
    private Object finishedSync = new Object();
    private FileInputStream fileInputStream;
    private SoundSource.DataFormat fileDataFormat;
    private Logger logger;

    public FileReader(String fileName, SoundSource.DataFormat fileDataFormat, Logger logger) {
        this.logger = logger;
        try {
            this.fileInputStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            logger.error("file not found: " + fileName, e);
        }
        this.fileDataFormat = fileDataFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.fileInputStream != null) {
            try {
                this.fileInputStream.close();
            }
            catch (IOException e) {
                this.logger.error("io exception", e);
            }
            this.fileInputStream = null;
            Object object = this.finishedSync;
            synchronized (object) {
                this.finishedSync.notifyAll();
            }
        }
    }

    @Override
    public SoundSource.DataFormat dataProduced() {
        return this.fileDataFormat != null ? this.fileDataFormat : SoundSource.DataFormat.DEFAULT;
    }

    @Override
    public synchronized byte[] readData() {
        if (this.fileInputStream == null) {
            return null;
        }
        byte[] buffer = new byte[256];
        try {
            int read = this.fileInputStream.read(buffer);
            if (read >= 0) {
                if (read < buffer.length) {
                    System.out.println("Buffer was not completely filled, but we are sending it all through anyway");
                }
                return buffer;
            }
            this.close();
        }
        catch (IOException e) {
            this.logger.error("io exception", e);
        }
        return null;
    }

    @Override
    public boolean finished() {
        return this.fileInputStream == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitFinished() throws InterruptedException {
        if (!this.finished()) {
            Object object = this.finishedSync;
            synchronized (object) {
                while (!this.finished()) {
                    this.finishedSync.wait();
                }
            }
        }
    }
}

