/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media.javaxsound;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.AbstractSoundManager;

public class JavaxSoundManager
extends AbstractSoundManager {
    private AudioFormat audioFormat;
    private TargetDataLine targetDataLine;
    private SourceDataLine sourceDataLine;
    private Object sourceDataLineMutex;
    private DataLine.Info targetInfo;
    private DataLine.Info sourceInfo;
    private FileOutputStream microphoneOutput;
    private FileOutputStream speakerInput;
    private boolean mediaDebug;
    private Logger logger;
    private String peersHome;

    public JavaxSoundManager(boolean mediaDebug, Logger logger, String peersHome) {
        this.mediaDebug = mediaDebug;
        this.logger = logger;
        this.peersHome = peersHome;
        if (peersHome == null) {
            this.peersHome = ".";
        }
        this.audioFormat = new AudioFormat(8000.0f, 16, 1, true, false);
        this.targetInfo = new DataLine.Info(TargetDataLine.class, this.audioFormat);
        this.sourceInfo = new DataLine.Info(SourceDataLine.class, this.audioFormat);
        this.sourceDataLineMutex = new Object();
    }

    @Override
    public void init() {
        this.logger.debug("openAndStartLines");
        if (this.mediaDebug) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String date = simpleDateFormat.format(new Date());
            StringBuffer buf = new StringBuffer();
            buf.append(this.peersHome).append(File.separator);
            buf.append("media").append(File.separator);
            buf.append(date).append("_");
            buf.append(this.audioFormat.getEncoding()).append("_");
            buf.append(this.audioFormat.getSampleRate()).append("_");
            buf.append(this.audioFormat.getSampleSizeInBits()).append("_");
            buf.append(this.audioFormat.getChannels()).append("_");
            buf.append(this.audioFormat.isBigEndian() ? "be" : "le");
            try {
                this.microphoneOutput = new FileOutputStream(buf.toString() + "_microphone.output");
                this.speakerInput = new FileOutputStream(buf.toString() + "_speaker.input");
            }
            catch (FileNotFoundException e) {
                this.logger.error("cannot create file", e);
                return;
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                try {
                    JavaxSoundManager.this.targetDataLine = (TargetDataLine)AudioSystem.getLine(JavaxSoundManager.this.targetInfo);
                    JavaxSoundManager.this.targetDataLine.open(JavaxSoundManager.this.audioFormat);
                }
                catch (LineUnavailableException e) {
                    JavaxSoundManager.this.logger.error("target line unavailable", e);
                    return null;
                }
                catch (SecurityException e) {
                    JavaxSoundManager.this.logger.error("security exception", e);
                    return null;
                }
                catch (Throwable t) {
                    JavaxSoundManager.this.logger.error("throwable " + t.getMessage());
                    return null;
                }
                JavaxSoundManager.this.targetDataLine.start();
                Object object = JavaxSoundManager.this.sourceDataLineMutex;
                synchronized (object) {
                    try {
                        JavaxSoundManager.this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(JavaxSoundManager.this.sourceInfo);
                        JavaxSoundManager.this.sourceDataLine.open(JavaxSoundManager.this.audioFormat);
                    }
                    catch (LineUnavailableException e) {
                        JavaxSoundManager.this.logger.error("source line unavailable", e);
                        return null;
                    }
                    JavaxSoundManager.this.sourceDataLine.start();
                }
                return null;
            }
        });
    }

    @Override
    public synchronized void close() {
        this.logger.debug("closeLines");
        if (this.microphoneOutput != null) {
            try {
                this.microphoneOutput.close();
            }
            catch (IOException e) {
                this.logger.error("cannot close file", e);
            }
            this.microphoneOutput = null;
        }
        if (this.speakerInput != null) {
            try {
                this.speakerInput.close();
            }
            catch (IOException e) {
                this.logger.error("cannot close file", e);
            }
            this.speakerInput = null;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                if (JavaxSoundManager.this.targetDataLine != null) {
                    JavaxSoundManager.this.targetDataLine.close();
                    JavaxSoundManager.this.targetDataLine = null;
                }
                Object object = JavaxSoundManager.this.sourceDataLineMutex;
                synchronized (object) {
                    if (JavaxSoundManager.this.sourceDataLine != null) {
                        JavaxSoundManager.this.sourceDataLine.drain();
                        JavaxSoundManager.this.sourceDataLine.stop();
                        JavaxSoundManager.this.sourceDataLine.close();
                        JavaxSoundManager.this.sourceDataLine = null;
                    }
                }
                return null;
            }
        });
    }

    @Override
    public synchronized byte[] readData() {
        if (this.targetDataLine == null) {
            return null;
        }
        int ready = this.targetDataLine.available();
        while (ready == 0) {
            try {
                Thread.sleep(2L);
                ready = this.targetDataLine.available();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        if (ready <= 0) {
            return null;
        }
        byte[] buffer = new byte[ready];
        this.targetDataLine.read(buffer, 0, buffer.length);
        if (this.mediaDebug) {
            try {
                this.microphoneOutput.write(buffer, 0, buffer.length);
            }
            catch (IOException e) {
                this.logger.error("cannot write to file", e);
                return null;
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeData(byte[] buffer, int offset, int length) {
        int numberOfBytesWritten;
        Object object = this.sourceDataLineMutex;
        synchronized (object) {
            if (this.sourceDataLine == null) {
                return 0;
            }
            numberOfBytesWritten = this.sourceDataLine.write(buffer, offset, length);
        }
        if (this.mediaDebug) {
            try {
                this.speakerInput.write(buffer, offset, numberOfBytesWritten);
            }
            catch (IOException e) {
                this.logger.error("cannot write to file", e);
                return -1;
            }
        }
        return numberOfBytesWritten;
    }
}

