/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.core.useragent;

import java.io.File;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.FileLogger;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.XmlConfig;
import net.sourceforge.peers.media.AbstractSoundManagerFactory;
import net.sourceforge.peers.media.ConfigAbstractSoundManagerFactory;
import net.sourceforge.peers.media.DtmfEventHandler;
import net.sourceforge.peers.media.Echo;
import net.sourceforge.peers.media.MediaManager;
import net.sourceforge.peers.media.MediaMode;
import net.sourceforge.peers.rtp.RFC4733;
import net.sourceforge.peers.sdp.SDPManager;
import net.sourceforge.peers.sip.core.useragent.ChallengeManager;
import net.sourceforge.peers.sip.core.useragent.InitialRequestManager;
import net.sourceforge.peers.sip.core.useragent.MidDialogRequestManager;
import net.sourceforge.peers.sip.core.useragent.SipListener;
import net.sourceforge.peers.sip.core.useragent.UAC;
import net.sourceforge.peers.sip.core.useragent.UAS;
import net.sourceforge.peers.sip.core.useragent.handlers.ByeHandler;
import net.sourceforge.peers.sip.core.useragent.handlers.CancelHandler;
import net.sourceforge.peers.sip.core.useragent.handlers.InviteHandler;
import net.sourceforge.peers.sip.core.useragent.handlers.OptionsHandler;
import net.sourceforge.peers.sip.core.useragent.handlers.RegisterHandler;
import net.sourceforge.peers.sip.syntaxencoding.SipURI;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import net.sourceforge.peers.sip.transaction.Transaction;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transactionuser.Dialog;
import net.sourceforge.peers.sip.transactionuser.DialogManager;
import net.sourceforge.peers.sip.transport.SipMessage;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.TransportManager;

public class UserAgent
implements DtmfEventHandler {
    public static final String CONFIG_FILE = "conf" + File.separator + "peers.xml";
    public static final int RTP_DEFAULT_PORT = 8000;
    private String peersHome;
    private Logger logger;
    private Config config;
    private List<String> peers;
    private Echo echo;
    private UAC uac;
    private UAS uas;
    private ChallengeManager challengeManager;
    private DialogManager dialogManager;
    private TransactionManager transactionManager;
    private TransportManager transportManager;
    private InviteHandler inviteHandler;
    private int cseqCounter;
    private AbstractSoundManagerFactory abstractSoundManagerFactory;
    private SipListener sipListener;
    private SDPManager sdpManager;
    private MediaManager mediaManager;

    public UserAgent(SipListener sipListener, String peersHome, Logger logger) throws SocketException {
        this(sipListener, null, peersHome, logger);
    }

    public UserAgent(SipListener sipListener, Config config, Logger logger) throws SocketException {
        this(sipListener, config, null, logger);
    }

    private UserAgent(SipListener sipListener, Config config, String peersHome, Logger logger) throws SocketException {
        this(sipListener, null, config, peersHome, logger);
    }

    public UserAgent(SipListener sipListener, AbstractSoundManagerFactory abstractSoundManagerFactory, Config config, String peersHome, Logger logger) throws SocketException {
        this.sipListener = sipListener;
        this.abstractSoundManagerFactory = abstractSoundManagerFactory;
        if (peersHome == null) {
            peersHome = ".";
        }
        this.peersHome = peersHome;
        if (logger == null) {
            logger = new FileLogger(this.peersHome);
        }
        this.logger = logger;
        if (config == null) {
            config = new XmlConfig(this.peersHome + File.separator + CONFIG_FILE, this.logger);
        }
        this.config = config;
        if (abstractSoundManagerFactory == null) {
            abstractSoundManagerFactory = new ConfigAbstractSoundManagerFactory(this.config, this.peersHome, this.logger);
        }
        this.abstractSoundManagerFactory = abstractSoundManagerFactory;
        this.cseqCounter = 1;
        StringBuffer buf = new StringBuffer();
        buf.append("starting user agent [");
        buf.append("myAddress: ");
        buf.append(config.getLocalInetAddress().getHostAddress()).append(", ");
        buf.append("sipPort: ");
        buf.append(config.getSipPort()).append(", ");
        buf.append("userpart: ");
        buf.append(config.getUserPart()).append(", ");
        buf.append("domain: ");
        buf.append(config.getDomain()).append("]");
        logger.info(buf.toString());
        this.dialogManager = new DialogManager(logger);
        this.transactionManager = new TransactionManager(logger);
        this.transportManager = new TransportManager(this.transactionManager, config, logger);
        this.transactionManager.setTransportManager(this.transportManager);
        this.inviteHandler = new InviteHandler(this, this.dialogManager, this.transactionManager, this.transportManager, logger);
        CancelHandler cancelHandler = new CancelHandler(this, this.dialogManager, this.transactionManager, this.transportManager, logger);
        ByeHandler byeHandler = new ByeHandler(this, this.dialogManager, this.transactionManager, this.transportManager, logger);
        OptionsHandler optionsHandler = new OptionsHandler(this, this.transactionManager, this.transportManager, logger);
        RegisterHandler registerHandler = new RegisterHandler(this, this.transactionManager, this.transportManager, logger);
        InitialRequestManager initialRequestManager = new InitialRequestManager(this, this.inviteHandler, cancelHandler, byeHandler, optionsHandler, registerHandler, this.dialogManager, this.transactionManager, this.transportManager, logger);
        MidDialogRequestManager midDialogRequestManager = new MidDialogRequestManager(this, this.inviteHandler, cancelHandler, byeHandler, optionsHandler, registerHandler, this.dialogManager, this.transactionManager, this.transportManager, logger);
        this.uas = new UAS(this, initialRequestManager, midDialogRequestManager, this.dialogManager, this.transactionManager, this.transportManager);
        this.uac = new UAC(this, initialRequestManager, midDialogRequestManager, this.dialogManager, this.transactionManager, this.transportManager, logger);
        this.challengeManager = new ChallengeManager(config, initialRequestManager, midDialogRequestManager, this.dialogManager, logger);
        registerHandler.setChallengeManager(this.challengeManager);
        this.inviteHandler.setChallengeManager(this.challengeManager);
        byeHandler.setChallengeManager(this.challengeManager);
        this.peers = new ArrayList<String>();
        this.sdpManager = new SDPManager(this, logger);
        this.inviteHandler.setSdpManager(this.sdpManager);
        optionsHandler.setSdpManager(this.sdpManager);
        this.mediaManager = new MediaManager(this, this, logger);
    }

    public void close() {
        this.transportManager.closeTransports();
        this.transactionManager.closeTimers();
        this.inviteHandler.closeTimers();
        this.mediaManager.stopSession();
        this.config.setPublicInetAddress(null);
    }

    public SipRequest register() throws SipUriSyntaxException {
        return this.uac.register();
    }

    public void unregister() throws SipUriSyntaxException {
        this.uac.unregister();
    }

    public SipRequest invite(String requestUri, String callId) throws SipUriSyntaxException {
        return this.uac.invite(requestUri, callId);
    }

    public void terminate(SipRequest sipRequest) {
        this.uac.terminate(sipRequest);
    }

    public void acceptCall(SipRequest sipRequest, Dialog dialog) {
        this.uas.acceptCall(sipRequest, dialog);
    }

    public void rejectCall(SipRequest sipRequest) {
        this.uas.rejectCall(sipRequest);
    }

    public SipRequest getSipRequest(SipMessage sipMessage) {
        if (sipMessage instanceof SipRequest) {
            return (SipRequest)sipMessage;
        }
        if (sipMessage instanceof SipResponse) {
            SipResponse sipResponse = (SipResponse)sipMessage;
            Transaction transaction = (Transaction)((Object)this.transactionManager.getClientTransaction(sipResponse));
            if (transaction == null) {
                transaction = (Transaction)((Object)this.transactionManager.getServerTransaction(sipResponse));
            }
            if (transaction == null) {
                return null;
            }
            return transaction.getRequest();
        }
        return null;
    }

    public List<String> getPeers() {
        return this.peers;
    }

    public String generateCSeq(String method) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.cseqCounter++);
        buf.append(' ');
        buf.append(method);
        return buf.toString();
    }

    public boolean isRegistered() {
        return this.uac.getInitialRequestManager().getRegisterHandler().isRegistered();
    }

    public UAS getUas() {
        return this.uas;
    }

    public UAC getUac() {
        return this.uac;
    }

    public DialogManager getDialogManager() {
        return this.dialogManager;
    }

    public int getSipPort() {
        return this.transportManager.getSipPort();
    }

    public int getRtpPort() {
        return this.config.getRtpPort();
    }

    public String getDomain() {
        return this.config.getDomain();
    }

    public String getUserpart() {
        return this.config.getUserPart();
    }

    public MediaMode getMediaMode() {
        return this.config.getMediaMode();
    }

    public boolean isMediaDebug() {
        return this.config.isMediaDebug();
    }

    public SipURI getOutboundProxy() {
        return this.config.getOutboundProxy();
    }

    public Echo getEcho() {
        return this.echo;
    }

    public void setEcho(Echo echo) {
        this.echo = echo;
    }

    public AbstractSoundManagerFactory getAbstractSoundManagerFactory() {
        return this.abstractSoundManagerFactory;
    }

    public SipListener getSipListener() {
        return this.sipListener;
    }

    public MediaManager getMediaManager() {
        return this.mediaManager;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getPeersHome() {
        return this.peersHome;
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    @Override
    public void dtmfDetected(RFC4733.DTMFEvent dtmfEvent, int duration) {
        this.sipListener.dtmfEvent(dtmfEvent, duration);
    }
}

