/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.core.useragent.handlers;

import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.core.useragent.RequestManager;
import net.sourceforge.peers.sip.core.useragent.SipListener;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.core.useragent.handlers.DialogMethodHandler;
import net.sourceforge.peers.sip.transaction.ClientTransaction;
import net.sourceforge.peers.sip.transaction.ClientTransactionUser;
import net.sourceforge.peers.sip.transaction.NonInviteClientTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransactionUser;
import net.sourceforge.peers.sip.transaction.Transaction;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transactionuser.Dialog;
import net.sourceforge.peers.sip.transactionuser.DialogManager;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.TransportManager;

public class ByeHandler
extends DialogMethodHandler
implements ServerTransactionUser,
ClientTransactionUser {
    public ByeHandler(UserAgent userAgent, DialogManager dialogManager, TransactionManager transactionManager, TransportManager transportManager, Logger logger) {
        super(userAgent, dialogManager, transactionManager, transportManager, logger);
    }

    public void preprocessBye(SipRequest sipRequest, Dialog dialog) {
        String addrSpec = sipRequest.getRequestUri().toString();
        this.userAgent.getPeers().remove(addrSpec);
        this.challengeManager.postProcess(sipRequest);
    }

    public void handleBye(SipRequest sipRequest, Dialog dialog) {
        dialog.receivedOrSentBye();
        String addrSpec = sipRequest.getRequestUri().toString();
        this.userAgent.getPeers().remove(addrSpec);
        this.dialogManager.removeDialog(dialog.getId());
        this.logger.debug("removed dialog " + dialog.getId());
        SipListener sipListener = this.userAgent.getSipListener();
        if (sipListener != null) {
            sipListener.remoteHangup(sipRequest);
        }
        this.userAgent.getMediaManager().stopSession();
        SipResponse sipResponse = RequestManager.generateResponse(sipRequest, dialog, 200, "OK");
        ServerTransaction serverTransaction = this.transactionManager.createServerTransaction(sipResponse, this.userAgent.getSipPort(), "UDP", this, sipRequest);
        serverTransaction.start();
        serverTransaction.receivedRequest(sipRequest);
        serverTransaction.sendReponse(sipResponse);
        this.dialogManager.removeDialog(dialog.getId());
    }

    @Override
    public void transactionFailure() {
    }

    @Override
    public void transactionTimeout(ClientTransaction clientTransaction) {
    }

    @Override
    public void provResponseReceived(SipResponse sipResponse, Transaction transaction) {
    }

    @Override
    public void errResponseReceived(SipResponse sipResponse) {
        int statusCode = sipResponse.getStatusCode();
        if (statusCode == 401 || statusCode == 407 && !this.challenged) {
            NonInviteClientTransaction nonInviteClientTransaction = (NonInviteClientTransaction)this.transactionManager.getClientTransaction(sipResponse);
            SipRequest sipRequest = nonInviteClientTransaction.getRequest();
            String password = this.userAgent.getConfig().getPassword();
            if (password != null && !"".equals(password.trim())) {
                this.challengeManager.handleChallenge(sipRequest, sipResponse);
            }
            this.challenged = true;
        } else {
            this.challenged = false;
        }
    }

    @Override
    public void successResponseReceived(SipResponse sipResponse, Transaction transaction) {
        Dialog dialog = this.dialogManager.getDialog(sipResponse);
        if (dialog == null) {
            return;
        }
        dialog.receivedOrSentBye();
        this.dialogManager.removeDialog(dialog.getId());
        this.logger.debug("removed dialog " + dialog.getId());
    }

    @Override
    public void transactionTransportError() {
    }
}

