/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.core.useragent.handlers;

import java.io.IOException;
import java.util.Random;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sdp.SessionDescription;
import net.sourceforge.peers.sip.Utils;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.core.useragent.handlers.MethodHandler;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.transaction.ServerTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransactionUser;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.TransportManager;

public class OptionsHandler
extends MethodHandler
implements ServerTransactionUser {
    public static final int MAX_PORTS = 65536;

    public OptionsHandler(UserAgent userAgent, TransactionManager transactionManager, TransportManager transportManager, Logger logger) {
        super(userAgent, transactionManager, transportManager, logger);
    }

    public void handleOptions(SipRequest sipRequest) {
        SipResponse sipResponse = this.buildGenericResponse(sipRequest, 200, "OK");
        int localPort = new Random().nextInt(65536);
        try {
            SessionDescription sessionDescription = this.sdpManager.createSessionDescription(null, localPort);
            sipResponse.setBody(sessionDescription.toString().getBytes());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
        SipHeaders sipHeaders = sipResponse.getSipHeaders();
        sipHeaders.add(new SipHeaderFieldName("Content-Type"), new SipHeaderFieldValue("application/sdp"));
        sipHeaders.add(new SipHeaderFieldName("Allow"), new SipHeaderFieldValue(Utils.generateAllowHeader()));
        ServerTransaction serverTransaction = this.transactionManager.createServerTransaction(sipResponse, this.userAgent.getSipPort(), "UDP", this, sipRequest);
        serverTransaction.start();
        serverTransaction.receivedRequest(sipRequest);
        serverTransaction.sendReponse(sipResponse);
    }

    @Override
    public void transactionFailure() {
    }
}

