/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transaction;

import java.io.IOException;
import java.util.TimerTask;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.Timer;
import net.sourceforge.peers.sip.transaction.InviteServerTransactionState;
import net.sourceforge.peers.sip.transaction.InviteServerTransactionStateCompleted;
import net.sourceforge.peers.sip.transaction.InviteServerTransactionStateConfirmed;
import net.sourceforge.peers.sip.transaction.InviteServerTransactionStateInit;
import net.sourceforge.peers.sip.transaction.InviteServerTransactionStateProceeding;
import net.sourceforge.peers.sip.transaction.InviteServerTransactionStateTerminated;
import net.sourceforge.peers.sip.transaction.InviteTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransactionUser;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transport.SipMessage;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.SipServerTransportUser;
import net.sourceforge.peers.sip.transport.TransportManager;

public class InviteServerTransaction
extends InviteTransaction
implements ServerTransaction,
SipServerTransportUser {
    public final InviteServerTransactionState INIT;
    public final InviteServerTransactionState PROCEEDING;
    public final InviteServerTransactionState COMPLETED;
    public final InviteServerTransactionState CONFIRMED;
    public final InviteServerTransactionState TERMINATED;
    protected String transport;
    protected int nbRetrans;
    protected ServerTransactionUser serverTransactionUser;
    private InviteServerTransactionState state;
    private int port;

    InviteServerTransaction(String branchId, int port, String transport, SipResponse sipResponse, ServerTransactionUser serverTransactionUser, SipRequest sipRequest, Timer timer, TransactionManager transactionManager, TransportManager transportManager, Logger logger) {
        super(branchId, timer, transportManager, transactionManager, logger);
        this.state = this.INIT = new InviteServerTransactionStateInit(this.getId(), this, logger);
        this.PROCEEDING = new InviteServerTransactionStateProceeding(this.getId(), this, logger);
        this.COMPLETED = new InviteServerTransactionStateCompleted(this.getId(), this, logger);
        this.CONFIRMED = new InviteServerTransactionStateConfirmed(this.getId(), this, logger);
        this.TERMINATED = new InviteServerTransactionStateTerminated(this.getId(), this, logger);
        this.request = sipRequest;
        this.port = port;
        this.transport = transport;
        this.responses.add(sipResponse);
        this.nbRetrans = 0;
        this.serverTransactionUser = serverTransactionUser;
    }

    @Override
    public void start() {
        this.state.start();
        try {
            this.transportManager.createServerTransport(this.transport, this.port);
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
        }
    }

    @Override
    public void receivedRequest(SipRequest sipRequest) {
        String method = sipRequest.getMethod();
        if ("INVITE".equals(method)) {
            this.state.receivedInvite();
        } else {
            this.state.receivedAck();
        }
    }

    @Override
    public void sendReponse(SipResponse sipResponse) {
        int statusCode;
        if (!this.responses.contains(sipResponse)) {
            this.responses.add(sipResponse);
        }
        if ((statusCode = sipResponse.getStatusCode()) != 100) {
            if (statusCode < 200) {
                this.state.received101To199();
            } else if (statusCode < 300) {
                this.state.received2xx();
            } else if (statusCode <= 699) {
                this.state.received300To699();
            } else {
                this.logger.error("invalid response code");
            }
        }
    }

    public void setState(InviteServerTransactionState state) {
        this.state.log(state);
        this.state = state;
    }

    @Override
    public void messageReceived(SipMessage sipMessage) {
    }

    void sendLastResponse() {
        int nbOfResponses = this.responses.size();
        if (nbOfResponses > 0) {
            try {
                this.transportManager.sendResponse((SipResponse)this.responses.get(nbOfResponses - 1));
            }
            catch (IOException e) {
                this.logger.error("input/output error", e);
            }
        }
    }

    @Override
    public SipResponse getLastResponse() {
        int nbOfResponses = this.responses.size();
        if (nbOfResponses > 0) {
            return (SipResponse)this.responses.get(nbOfResponses - 1);
        }
        return null;
    }

    class TimerI
    extends TimerTask {
        TimerI() {
        }

        @Override
        public void run() {
            InviteServerTransaction.this.state.timerIFires();
        }
    }

    class TimerH
    extends TimerTask {
        TimerH() {
        }

        @Override
        public void run() {
            InviteServerTransaction.this.state.timerHFiresOrTransportError();
        }
    }

    class TimerG
    extends TimerTask {
        TimerG() {
        }

        @Override
        public void run() {
            InviteServerTransaction.this.state.timerGFires();
        }
    }
}

