/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transaction;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.Timer;
import net.sourceforge.peers.sip.Utils;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.transaction.ClientTransaction;
import net.sourceforge.peers.sip.transaction.ClientTransactionUser;
import net.sourceforge.peers.sip.transaction.InviteClientTransaction;
import net.sourceforge.peers.sip.transaction.InviteServerTransaction;
import net.sourceforge.peers.sip.transaction.NonInviteClientTransaction;
import net.sourceforge.peers.sip.transaction.NonInviteServerTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransactionUser;
import net.sourceforge.peers.sip.transaction.Transaction;
import net.sourceforge.peers.sip.transport.SipMessage;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.TransportManager;

public class TransactionManager {
    protected Timer timer;
    private Hashtable<String, ClientTransaction> clientTransactions;
    private Hashtable<String, ServerTransaction> serverTransactions;
    private TransportManager transportManager;
    private Logger logger;

    public TransactionManager(Logger logger) {
        this.logger = logger;
        this.clientTransactions = new Hashtable();
        this.serverTransactions = new Hashtable();
        this.timer = new Timer(TransactionManager.class.getSimpleName() + " " + Timer.class.getSimpleName());
    }

    public void closeTimers() {
        this.timer.cancel();
    }

    public ClientTransaction createClientTransaction(SipRequest sipRequest, InetAddress inetAddress, int port, String transport, String pBranchId, ClientTransactionUser clientTransactionUser) {
        String branchId = pBranchId == null || "".equals(pBranchId.trim()) || !pBranchId.startsWith("z9hG4bK") ? Utils.generateBranchId() : pBranchId;
        String method = sipRequest.getMethod();
        Transaction clientTransaction = "INVITE".equals(method) ? new InviteClientTransaction(branchId, inetAddress, port, transport, sipRequest, clientTransactionUser, this.timer, this.transportManager, this, this.logger) : new NonInviteClientTransaction(branchId, inetAddress, port, transport, sipRequest, clientTransactionUser, this.timer, this.transportManager, this, this.logger);
        this.clientTransactions.put(this.getTransactionId(branchId, method), (ClientTransaction)((Object)clientTransaction));
        return clientTransaction;
    }

    public ServerTransaction createServerTransaction(SipResponse sipResponse, int port, String transport, ServerTransactionUser serverTransactionUser, SipRequest sipRequest) {
        SipHeaderFieldValue via = Utils.getTopVia(sipResponse);
        String branchId = via.getParam(new SipHeaderParamName("branch"));
        String cseq = sipResponse.getSipHeaders().get(new SipHeaderFieldName("CSeq")).toString();
        String method = cseq.substring(cseq.lastIndexOf(32) + 1);
        Transaction serverTransaction = "INVITE".equals(method) ? new InviteServerTransaction(branchId, port, transport, sipResponse, serverTransactionUser, sipRequest, this.timer, this, this.transportManager, this.logger) : new NonInviteServerTransaction(branchId, port, transport, method, serverTransactionUser, sipRequest, this.timer, this.transportManager, this, this.logger);
        this.serverTransactions.put(this.getTransactionId(branchId, method), (ServerTransaction)((Object)serverTransaction));
        return serverTransaction;
    }

    public ClientTransaction getClientTransaction(SipMessage sipMessage) {
        SipHeaderFieldValue via = Utils.getTopVia(sipMessage);
        String branchId = via.getParam(new SipHeaderParamName("branch"));
        String cseq = sipMessage.getSipHeaders().get(new SipHeaderFieldName("CSeq")).toString();
        String method = cseq.substring(cseq.lastIndexOf(32) + 1);
        return this.clientTransactions.get(this.getTransactionId(branchId, method));
    }

    public List<ClientTransaction> getClientTransactionsFromCallId(String callId, String method) {
        ArrayList<ClientTransaction> clientTransactionsFromCallId = new ArrayList<ClientTransaction>();
        for (ClientTransaction clientTransaction : this.clientTransactions.values()) {
            Transaction transaction = (Transaction)((Object)clientTransaction);
            SipRequest sipRequest = transaction.getRequest();
            String reqCallId = Utils.getMessageCallId(sipRequest);
            String reqMethod = sipRequest.getMethod();
            if (!reqCallId.equals(callId) || !method.equals(reqMethod)) continue;
            clientTransactionsFromCallId.add(clientTransaction);
        }
        return clientTransactionsFromCallId;
    }

    public ServerTransaction getServerTransaction(SipMessage sipMessage) {
        String method;
        SipHeaderFieldValue via = Utils.getTopVia(sipMessage);
        String branchId = via.getParam(new SipHeaderParamName("branch"));
        if (sipMessage instanceof SipRequest) {
            method = ((SipRequest)sipMessage).getMethod();
        } else {
            String cseq = sipMessage.getSipHeaders().get(new SipHeaderFieldName("CSeq")).toString();
            method = cseq.substring(cseq.lastIndexOf(32) + 1);
        }
        if ("ACK".equals(method)) {
            method = "INVITE";
        }
        return this.serverTransactions.get(this.getTransactionId(branchId, method));
    }

    public ServerTransaction getServerTransaction(String branchId, String method) {
        return this.serverTransactions.get(this.getTransactionId(branchId, method));
    }

    void removeServerTransaction(String branchId, String method) {
        this.serverTransactions.remove(this.getTransactionId(branchId, method));
    }

    void removeClientTransaction(String branchId, String method) {
        this.clientTransactions.remove(this.getTransactionId(branchId, method));
    }

    private String getTransactionId(String branchId, String method) {
        StringBuffer buf = new StringBuffer();
        buf.append(branchId);
        buf.append('|');
        buf.append(method);
        return buf.toString();
    }

    public void setTransportManager(TransportManager transportManager) {
        this.transportManager = transportManager;
    }
}

