/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transactionuser;

import java.util.ArrayList;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.Utils;
import net.sourceforge.peers.sip.syntaxencoding.NameAddress;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldMultiValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.syntaxencoding.SipURI;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import net.sourceforge.peers.sip.transactionuser.DialogState;
import net.sourceforge.peers.sip.transactionuser.DialogStateConfirmed;
import net.sourceforge.peers.sip.transactionuser.DialogStateEarly;
import net.sourceforge.peers.sip.transactionuser.DialogStateInit;
import net.sourceforge.peers.sip.transactionuser.DialogStateTerminated;
import net.sourceforge.peers.sip.transport.SipRequest;

public class Dialog {
    public static final char ID_SEPARATOR = '|';
    public static final int EMPTY_CSEQ = -1;
    public final DialogState INIT;
    public final DialogState EARLY;
    public final DialogState CONFIRMED;
    public final DialogState TERMINATED;
    private DialogState state;
    private String callId;
    private String localTag;
    private String remoteTag;
    private int localCSeq;
    private int remoteCSeq;
    private String localUri;
    private String remoteUri;
    private String remoteTarget;
    private boolean secure;
    private ArrayList<String> routeSet;
    private Logger logger;

    Dialog(String callId, String localTag, String remoteTag, Logger logger) {
        this.callId = callId;
        this.localTag = localTag;
        this.remoteTag = remoteTag;
        this.logger = logger;
        this.state = this.INIT = new DialogStateInit(this.getId(), this, logger);
        this.EARLY = new DialogStateEarly(this.getId(), this, logger);
        this.CONFIRMED = new DialogStateConfirmed(this.getId(), this, logger);
        this.TERMINATED = new DialogStateTerminated(this.getId(), this, logger);
        this.localCSeq = -1;
        this.remoteCSeq = -1;
    }

    public void receivedOrSent1xx() {
        this.state.receivedOrSent101To199();
    }

    public void receivedOrSent2xx() {
        this.state.receivedOrSent2xx();
    }

    public void receivedOrSent300To699() {
        this.state.receivedOrSent300To699();
    }

    public void receivedOrSentBye() {
        this.state.receivedOrSentBye();
    }

    public void setState(DialogState state) {
        this.state.log(state);
        this.state = state;
    }

    public SipRequest buildSubsequentRequest(String method) {
        SipURI sipUri;
        try {
            sipUri = new SipURI(this.remoteTarget);
        }
        catch (SipUriSyntaxException e) {
            throw new RuntimeException(e);
        }
        SipRequest subsequentRequest = new SipRequest(method, sipUri);
        SipHeaders headers = subsequentRequest.getSipHeaders();
        SipHeaderFieldValue to = new SipHeaderFieldValue(new NameAddress(this.remoteUri).toString());
        if (this.remoteTag != null) {
            to.addParam(new SipHeaderParamName("tag"), this.remoteTag);
        }
        headers.add(new SipHeaderFieldName("To"), to);
        SipHeaderFieldValue from = new SipHeaderFieldValue(new NameAddress(this.localUri).toString());
        if (this.localTag != null) {
            from.addParam(new SipHeaderParamName("tag"), this.localTag);
        }
        headers.add(new SipHeaderFieldName("From"), from);
        SipHeaderFieldValue callIdValue = new SipHeaderFieldValue(this.callId);
        headers.add(new SipHeaderFieldName("Call-ID"), callIdValue);
        this.localCSeq = this.localCSeq == -1 ? ((int)(System.currentTimeMillis() / 1000L) & 0xFFFFFFFE) >> 1 : ++this.localCSeq;
        headers.add(new SipHeaderFieldName("CSeq"), new SipHeaderFieldValue(this.localCSeq + " " + method));
        if (!this.routeSet.isEmpty()) {
            if (this.routeSet.get(0).contains("lr")) {
                ArrayList<SipHeaderFieldValue> routes = new ArrayList<SipHeaderFieldValue>();
                for (String route : this.routeSet) {
                    routes.add(new SipHeaderFieldValue(route));
                }
                headers.add(new SipHeaderFieldName("Route"), new SipHeaderFieldMultiValue(routes));
            } else {
                this.logger.error("Trying to forward to a strict router, forbidden in this implementation");
            }
        }
        Utils.addCommonHeaders(headers);
        return subsequentRequest;
    }

    public String getId() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.callId).append('|');
        buf.append(this.localTag).append('|');
        buf.append(this.remoteTag);
        return buf.toString();
    }

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public int getLocalCSeq() {
        return this.localCSeq;
    }

    public void setLocalCSeq(int localCSeq) {
        this.localCSeq = localCSeq;
    }

    public String getLocalUri() {
        return this.localUri;
    }

    public void setLocalUri(String localUri) {
        this.localUri = localUri;
    }

    public int getRemoteCSeq() {
        return this.remoteCSeq;
    }

    public void setRemoteCSeq(int remoteCSeq) {
        this.remoteCSeq = remoteCSeq;
    }

    public String getRemoteTarget() {
        return this.remoteTarget;
    }

    public void setRemoteTarget(String remoteTarget) {
        this.remoteTarget = remoteTarget;
    }

    public String getRemoteUri() {
        return this.remoteUri;
    }

    public void setRemoteUri(String remoteUri) {
        this.remoteUri = remoteUri;
    }

    public ArrayList<String> getRouteSet() {
        return this.routeSet;
    }

    public void setRouteSet(ArrayList<String> routeSet) {
        this.routeSet = routeSet;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getLocalTag() {
        return this.localTag;
    }

    public void setLocalTag(String localTag) {
        this.localTag = localTag;
    }

    public String getRemoteTag() {
        return this.remoteTag;
    }

    public void setRemoteTag(String remoteTag) {
        this.remoteTag = remoteTag;
    }

    public DialogState getState() {
        return this.state;
    }
}

