/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transport;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.Utils;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.syntaxencoding.SipParserException;
import net.sourceforge.peers.sip.transaction.ClientTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransaction;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transport.MessageSender;
import net.sourceforge.peers.sip.transport.SipMessage;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.SipServerTransportUser;
import net.sourceforge.peers.sip.transport.SipTransportConnection;
import net.sourceforge.peers.sip.transport.TransportManager;

public abstract class MessageReceiver
implements Runnable {
    public static final int BUFFER_SIZE = 2048;
    public static final String CHARACTER_ENCODING = "US-ASCII";
    protected int port;
    private boolean isListening;
    private SipServerTransportUser sipServerTransportUser;
    private TransactionManager transactionManager;
    private TransportManager transportManager;
    private Config config;
    protected Logger logger;

    public MessageReceiver(int port, TransactionManager transactionManager, TransportManager transportManager, Config config, Logger logger) {
        this.port = port;
        this.transactionManager = transactionManager;
        this.transportManager = transportManager;
        this.config = config;
        this.logger = logger;
        this.isListening = true;
    }

    @Override
    public void run() {
        while (this.isListening) {
            try {
                this.listen();
            }
            catch (IOException e) {
                this.logger.error("input/output error", e);
            }
        }
    }

    protected abstract void listen() throws IOException;

    protected boolean isRequest(byte[] message) {
        String beginning = null;
        try {
            beginning = new String(message, 0, "SIP/2.0".length(), CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("unsupported encoding", e);
        }
        return !"SIP/2.0".equals(beginning);
    }

    protected void processMessage(byte[] message, InetAddress sourceIp, int sourcePort, String transport) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(message);
        InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
        BufferedReader reader = new BufferedReader(inputStreamReader);
        String startLine = reader.readLine();
        while ("".equals(startLine)) {
            startLine = reader.readLine();
        }
        if (startLine == null) {
            return;
        }
        if (!startLine.contains("SIP/2.0")) {
            SipTransportConnection sipTransportConnection = new SipTransportConnection(this.config.getLocalInetAddress(), this.port, sourceIp, sourcePort, transport);
            MessageSender messageSender = this.transportManager.getMessageSender(sipTransportConnection);
            if (messageSender != null) {
                messageSender.sendBytes(message);
            }
            return;
        }
        StringBuffer direction = new StringBuffer();
        direction.append("RECEIVED from ").append(sourceIp.getHostAddress());
        direction.append("/").append(sourcePort);
        this.logger.traceNetwork(new String(message), direction.toString());
        SipMessage sipMessage = null;
        try {
            sipMessage = this.transportManager.sipParser.parse(new ByteArrayInputStream(message));
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
        }
        catch (SipParserException e) {
            this.logger.error("SIP parser error", e);
        }
        if (sipMessage == null) {
            return;
        }
        if (sipMessage instanceof SipRequest) {
            ServerTransaction serverTransaction;
            SipHeaderParamName rportName;
            String rport;
            SipRequest sipRequest = (SipRequest)sipMessage;
            SipHeaderFieldValue topVia = Utils.getTopVia(sipRequest);
            String sentBy = topVia.getParam(new SipHeaderParamName("sent-by"));
            if (sentBy != null) {
                int colonPos = sentBy.indexOf(58);
                if (colonPos < 0) {
                    colonPos = sentBy.length();
                }
                if (!InetAddress.getByName(sentBy = sentBy.substring(0, colonPos)).equals(sourceIp)) {
                    topVia.addParam(new SipHeaderParamName("received"), sourceIp.getHostAddress());
                }
            }
            if ((rport = topVia.getParam(rportName = new SipHeaderParamName("rport"))) != null && "".equals(rport)) {
                topVia.removeParam(rportName);
                topVia.addParam(rportName, String.valueOf(sourcePort));
            }
            if ((serverTransaction = this.transactionManager.getServerTransaction(sipRequest)) == null) {
                this.sipServerTransportUser.messageReceived(sipMessage);
            } else {
                serverTransaction.receivedRequest(sipRequest);
            }
        } else {
            SipResponse sipResponse = (SipResponse)sipMessage;
            ClientTransaction clientTransaction = this.transactionManager.getClientTransaction(sipResponse);
            this.logger.debug("ClientTransaction = " + clientTransaction);
            if (clientTransaction == null) {
                this.sipServerTransportUser.messageReceived(sipMessage);
            } else {
                clientTransaction.receivedResponse(sipResponse);
            }
        }
    }

    public synchronized void setListening(boolean isListening) {
        this.isListening = isListening;
    }

    public synchronized boolean isListening() {
        return this.isListening;
    }

    public void setSipServerTransportUser(SipServerTransportUser sipServerTransportUser) {
        this.sipServerTransportUser = sipServerTransportUser;
    }
}

