/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transport;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transport.MessageReceiver;
import net.sourceforge.peers.sip.transport.TransportManager;

public class UdpMessageReceiver
extends MessageReceiver {
    private DatagramSocket datagramSocket;

    public UdpMessageReceiver(DatagramSocket datagramSocket, TransactionManager transactionManager, TransportManager transportManager, Config config, Logger logger) throws SocketException {
        super(datagramSocket.getLocalPort(), transactionManager, transportManager, config, logger);
        this.datagramSocket = datagramSocket;
    }

    @Override
    protected void listen() throws IOException {
        byte[] buf = new byte[2048];
        final DatagramPacket packet = new DatagramPacket(buf, buf.length);
        boolean noException = false;
        boolean socketTimeoutException = true;
        int ioException = 2;
        int result = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    UdpMessageReceiver.this.datagramSocket.receive(packet);
                }
                catch (SocketTimeoutException e) {
                    return 1;
                }
                catch (SocketException e) {
                    if (e.getMessage().equals("Socket closed") && !UdpMessageReceiver.this.isListening()) {
                        return 0;
                    }
                    return 2;
                }
                catch (IOException e) {
                    UdpMessageReceiver.this.logger.error("cannot receive packet", e);
                    return 2;
                }
                return 0;
            }
        });
        switch (result) {
            case 1: {
                return;
            }
            case 2: {
                throw new IOException();
            }
            case 0: {
                break;
            }
        }
        byte[] trimmedPacket = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), 0, trimmedPacket, 0, trimmedPacket.length);
        this.processMessage(trimmedPacket, packet.getAddress(), packet.getPort(), "UDP");
    }
}

