/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transport;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.transport.MessageSender;
import net.sourceforge.peers.sip.transport.SipMessage;

public class UdpMessageSender
extends MessageSender {
    private DatagramSocket datagramSocket;

    public UdpMessageSender(InetAddress inetAddress, int port, DatagramSocket datagramSocket, Config config, Logger logger) throws SocketException {
        super(datagramSocket.getLocalPort(), inetAddress, port, config, "UDP", logger);
        this.datagramSocket = datagramSocket;
    }

    @Override
    public synchronized void sendMessage(SipMessage sipMessage) throws IOException {
        this.logger.debug("UdpMessageSender.sendMessage");
        if (sipMessage == null) {
            return;
        }
        byte[] buf = sipMessage.toString().getBytes();
        this.sendBytes(buf);
        StringBuffer direction = new StringBuffer();
        direction.append("SENT to ").append(this.inetAddress.getHostAddress());
        direction.append("/").append(this.port);
        this.logger.traceNetwork(new String(buf), direction.toString());
    }

    @Override
    public synchronized void sendBytes(final byte[] bytes) throws IOException {
        this.logger.debug("UdpMessageSender.sendBytes");
        final DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.inetAddress, this.port);
        this.logger.debug("UdpMessageSender.sendBytes " + bytes.length + " " + this.inetAddress + ":" + this.port);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    if (!UdpMessageSender.this.datagramSocket.isClosed()) {
                        UdpMessageSender.this.logger.debug("Local internet-address: " + UdpMessageSender.this.datagramSocket.getLocalAddress().toString());
                        UdpMessageSender.this.datagramSocket.send(packet);
                    } else {
                        UdpMessageSender.this.logger.error("Socket closed. Packet of " + bytes.length + " bytes not sent to " + UdpMessageSender.this.inetAddress + ":" + UdpMessageSender.this.port);
                    }
                }
                catch (Throwable t) {
                    UdpMessageSender.this.logger.error("throwable", new Exception(t));
                }
                return null;
            }
        });
        this.logger.debug("UdpMessageSender.sendBytes packet sent");
    }
}

