/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jwebsocket.api.WebSocketClientListener;
import org.jwebsocket.client.java.BaseWebSocket;
import org.jwebsocket.kit.WebSocketException;
import to.sparks.mtgox.MTGOXAPI;
import to.sparks.mtgox.dto.Depth;
import to.sparks.mtgox.dto.FullDepth;
import to.sparks.mtgox.dto.Offer;
import to.sparks.mtgox.dto.Result;
import to.sparks.mtgox.dto.Ticker;
import to.sparks.mtgox.util.JSONSource;
import to.sparks.mtgox.util.MtGoxListener;
import to.sparks.mtgox.util.MtGoxSocket;

public class MtGoxRealTime
implements MtGoxListener {
    private static final Logger logger = Logger.getLogger(MtGoxRealTime.class.getName());
    private List<Depth> depthHistory = new CopyOnWriteArrayList<Depth>();
    private List<Ticker> tickerHistory = new CopyOnWriteArrayList<Ticker>();

    public MtGoxRealTime() throws WebSocketException {
        final BaseWebSocket websocket = new BaseWebSocket();
        websocket.addListener((WebSocketClientListener)new MtGoxSocket(this, logger));
        websocket.open("ws://websocket.mtgox.com/mtgox");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Closing connection...");
                try {
                    websocket.close();
                }
                catch (WebSocketException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    public List<Depth> getAllDepthSince(long timestamp) {
        List<Depth> result = new ArrayList<Depth>();
        int length = this.depthHistory.size();
        for (int i = 0; i < length; ++i) {
            Depth depth = this.depthHistory.get(i);
            if (depth.getStamp() <= timestamp) continue;
            result = this.depthHistory.subList(i, length - 1);
            break;
        }
        return result;
    }

    public static void main(String[] args) throws WebSocketException, IOException, InterruptedException {
        long mostRecentBidTimestamp;
        MtGoxRealTime mtGoxSocket = new MtGoxRealTime();
        JSONSource fullDepthJSON = new JSONSource();
        FullDepth fullDepthUSD = (FullDepth)((Result)fullDepthJSON.getResultFromStream(new URL("https://mtgox.com/api/1/BTCUSD/fulldepth").openStream(), FullDepth.class)).getReturn();
        ArrayList<Offer> asksUSD = new ArrayList<Offer>(Arrays.asList(fullDepthUSD.getAsks()));
        ArrayList<Offer> bidsUSD = new ArrayList<Offer>(Arrays.asList(fullDepthUSD.getBids()));
        long mostRecentAskTimestamp = MtGoxRealTime.getMostRecentTimestamp(asksUSD);
        long mostRecentTimestamp = mostRecentAskTimestamp < (mostRecentBidTimestamp = MtGoxRealTime.getMostRecentTimestamp(bidsUSD)) ? mostRecentBidTimestamp : mostRecentAskTimestamp;
        while (true) {
            Thread.sleep(1000L);
            List<Depth> updates = mtGoxSocket.getAllDepthSince(mostRecentTimestamp);
            for (Depth update : updates) {
                if (update.getStamp() < mostRecentTimestamp) {
                    logger.log(Level.WARNING, "Warning:  Out of order timestamp found. {0} < {1}", new Object[]{update.getStamp(), mostRecentTimestamp});
                    continue;
                }
                mostRecentTimestamp = update.getStamp();
                if (!update.getCurrency().equalsIgnoreCase("USD")) continue;
                if (update.getType_str().equalsIgnoreCase("ASK")) {
                    MtGoxRealTime.updateDepth(update, asksUSD, MTGOXAPI.USD_INT_MULTIPLIER);
                    continue;
                }
                MtGoxRealTime.updateDepth(update, bidsUSD, MTGOXAPI.USD_INT_MULTIPLIER);
            }
            logger.log(Level.INFO, "Asks: {0}  Bids: {1}", new Object[]{asksUSD.size(), bidsUSD.size()});
        }
    }

    @Override
    public void tickerEvent(Ticker ticker) {
        this.tickerHistory.add(ticker);
    }

    @Override
    public void depthEvent(Depth depth) {
        this.depthHistory.add(depth);
    }

    private static void updateDepth(Depth update, List<Offer> depth, double covertToIntFactor) {
        ArrayList<Offer> emptyOffers = new ArrayList<Offer>();
        for (Offer offer : depth) {
            if (offer.getAmount_int() == 0L) {
                emptyOffers.add(offer);
            }
            if (offer.getPrice_int() != update.getPrice_int()) continue;
            double dAmount = (double)update.getTotal_volume_int() / covertToIntFactor;
            logger.log(Level.INFO, "Update at price {0}   Old volume: {1}  New volume: {2}", new Object[]{offer.getPrice(), offer.getAmount(), dAmount});
            offer.setAmount_int(update.getTotal_volume_int());
            offer.setAmount(dAmount);
            offer.setStamp(update.getStamp());
            break;
        }
        if (update.getAmount_int() > 0L) {
            logger.log(Level.INFO, "New offer at price {0}   volume: {1}  (total {2})", new Object[]{update.getPrice(), update.getAmount(), update.getTotal_volume_int()});
            Offer offer = new Offer(update.getPrice(), update.getAmount(), update.getPrice_int(), update.getAmount_int(), update.getStamp());
            depth.add(offer);
        }
        for (Offer offer : emptyOffers) {
            depth.remove(offer);
        }
    }

    private static long getMostRecentTimestamp(List<Offer> offers) {
        long mostRecentTimestamp = 0L;
        for (Offer offer : offers) {
            if (offer.getStamp() <= mostRecentTimestamp) continue;
            mostRecentTimestamp = offer.getStamp();
        }
        return mostRecentTimestamp;
    }
}

